/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DHPrivateKey;
import com.sun.crypto.provider.DHPublicKey;
import com.sun.crypto.provider.SunJCE;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import sun.security.provider.ParameterCache;

public final class DHKeyPairGenerator
extends KeyPairGeneratorSpi {
    private DHParameterSpec params;
    private int pSize;
    private int lSize;
    private SecureRandom random;

    public DHKeyPairGenerator() {
        this.initialize(1024, null);
    }

    @Override
    public void initialize(int keysize, SecureRandom random) {
        if (keysize < 512 || keysize > 4096 || keysize % 64 != 0) {
            throw new InvalidParameterException("Keysize must be multiple of 64, and can only range from 512 to 4096 (inclusive)");
        }
        this.pSize = keysize;
        this.lSize = 0;
        this.random = random;
        this.params = null;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algParams, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(algParams instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        this.params = (DHParameterSpec)algParams;
        this.pSize = this.params.getP().bitLength();
        if (this.pSize < 512 || this.pSize > 4096 || this.pSize % 64 != 0) {
            throw new InvalidAlgorithmParameterException("Prime size must be multiple of 64, and can only range from 512 to 4096 (inclusive)");
        }
        this.lSize = this.params.getL();
        if (this.lSize != 0 && this.lSize > this.pSize) {
            throw new InvalidAlgorithmParameterException("Exponent size must not be larger than modulus size");
        }
        this.random = random;
    }

    @Override
    public KeyPair generateKeyPair() {
        BigInteger x;
        if (this.random == null) {
            this.random = SunJCE.getRandom();
        }
        if (this.params == null) {
            try {
                this.params = ParameterCache.getDHParameterSpec(this.pSize, this.random);
            }
            catch (GeneralSecurityException e) {
                throw new ProviderException(e);
            }
        }
        BigInteger p = this.params.getP();
        BigInteger g = this.params.getG();
        if (this.lSize <= 0) {
            this.lSize = this.pSize >> 1;
            if (this.lSize < 384) {
                this.lSize = 384;
            }
        }
        BigInteger pMinus2 = p.subtract(BigInteger.valueOf(2L));
        while ((x = new BigInteger(this.lSize, this.random)).compareTo(BigInteger.ONE) < 0 || x.compareTo(pMinus2) > 0 || x.bitLength() != this.lSize) {
        }
        BigInteger y = g.modPow(x, p);
        DHPublicKey pubKey = new DHPublicKey(y, p, g, this.lSize);
        DHPrivateKey privKey = new DHPrivateKey(x, p, g, this.lSize);
        return new KeyPair(pubKey, privKey);
    }
}

