/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.EncryptedPrivateKeyInfo;
import com.sun.crypto.provider.KeyProtector;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.crypto.SealedObject;

public final class JceKeyStore
extends KeyStoreSpi {
    private static final int JCEKS_MAGIC = -825307442;
    private static final int JKS_MAGIC = -17957139;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private Hashtable<String, Object> entries = new Hashtable();

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Key key = null;
        Object entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (!(entry instanceof PrivateKeyEntry) && !(entry instanceof SecretKeyEntry)) {
            return null;
        }
        KeyProtector keyProtector = new KeyProtector(password);
        if (entry instanceof PrivateKeyEntry) {
            EncryptedPrivateKeyInfo encrInfo;
            byte[] encrBytes = ((PrivateKeyEntry)entry).protectedKey;
            try {
                encrInfo = new EncryptedPrivateKeyInfo(encrBytes);
            }
            catch (IOException ioe) {
                throw new UnrecoverableKeyException("Private key not stored as PKCS #8 EncryptedPrivateKeyInfo");
            }
            key = keyProtector.recover(encrInfo);
        } else {
            key = keyProtector.unseal(((SecretKeyEntry)entry).sealedKey);
        }
        return key;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] chain = null;
        Object entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry instanceof PrivateKeyEntry && ((PrivateKeyEntry)entry).chain != null) {
            chain = (Certificate[])((PrivateKeyEntry)entry).chain.clone();
        }
        return chain;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Certificate cert = null;
        Object entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry != null) {
            if (entry instanceof TrustedCertEntry) {
                cert = ((TrustedCertEntry)entry).cert;
            } else if (entry instanceof PrivateKeyEntry && ((PrivateKeyEntry)entry).chain != null) {
                cert = ((PrivateKeyEntry)entry).chain[0];
            }
        }
        return cert;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        Date date = null;
        Object entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry != null) {
            date = entry instanceof TrustedCertEntry ? new Date(((TrustedCertEntry)entry).date.getTime()) : (entry instanceof PrivateKeyEntry ? new Date(((PrivateKeyEntry)entry).date.getTime()) : new Date(((SecretKeyEntry)entry).date.getTime()));
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            try {
                KeyProtector keyProtector = new KeyProtector(password);
                if (key instanceof PrivateKey) {
                    PrivateKeyEntry entry = new PrivateKeyEntry();
                    entry.date = new Date();
                    entry.protectedKey = keyProtector.protect((PrivateKey)key);
                    entry.chain = chain != null && chain.length != 0 ? (Certificate[])chain.clone() : null;
                    this.entries.put(alias.toLowerCase(Locale.ENGLISH), entry);
                } else {
                    SecretKeyEntry entry = new SecretKeyEntry();
                    entry.date = new Date();
                    entry.sealedKey = keyProtector.seal(key);
                    this.entries.put(alias.toLowerCase(Locale.ENGLISH), entry);
                }
            }
            catch (Exception e) {
                throw new KeyStoreException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            PrivateKeyEntry entry = new PrivateKeyEntry();
            entry.date = new Date();
            entry.protectedKey = (byte[])key.clone();
            entry.chain = chain != null && chain.length != 0 ? (Certificate[])chain.clone() : null;
            this.entries.put(alias.toLowerCase(Locale.ENGLISH), entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            Object entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
            if (entry != null) {
                if (entry instanceof PrivateKeyEntry) {
                    throw new KeyStoreException("Cannot overwrite own certificate");
                }
                if (entry instanceof SecretKeyEntry) {
                    throw new KeyStoreException("Cannot overwrite secret key");
                }
            }
            TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
            trustedCertEntry.cert = cert;
            trustedCertEntry.date = new Date();
            this.entries.put(alias.toLowerCase(Locale.ENGLISH), trustedCertEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            this.entries.remove(alias.toLowerCase(Locale.ENGLISH));
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.entries.containsKey(alias.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        boolean isKey = false;
        Object entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry instanceof PrivateKeyEntry || entry instanceof SecretKeyEntry) {
            isKey = true;
        }
        return isKey;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        boolean isCert = false;
        Object entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry instanceof TrustedCertEntry) {
            isCert = true;
        }
        return isCert;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        Enumeration<String> e = this.entries.keys();
        while (e.hasMoreElements()) {
            Certificate certElem;
            String alias = e.nextElement();
            Object entry = this.entries.get(alias);
            if (entry instanceof TrustedCertEntry) {
                certElem = ((TrustedCertEntry)entry).cert;
            } else {
                if (!(entry instanceof PrivateKeyEntry) || ((PrivateKeyEntry)entry).chain == null) continue;
                certElem = ((PrivateKeyEntry)entry).chain[0];
            }
            if (!certElem.equals(cert)) continue;
            return alias;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            if (password == null) {
                throw new IllegalArgumentException("password can't be null");
            }
            MessageDigest md = this.getPreKeyedHash(password);
            DataOutputStream dos = new DataOutputStream(new DigestOutputStream(stream, md));
            ObjectOutputStream oos = null;
            try {
                dos.writeInt(-825307442);
                dos.writeInt(2);
                dos.writeInt(this.entries.size());
                Enumeration<String> e = this.entries.keys();
                while (e.hasMoreElements()) {
                    byte[] encoded;
                    String alias = e.nextElement();
                    Object entry = this.entries.get(alias);
                    if (entry instanceof PrivateKeyEntry) {
                        PrivateKeyEntry pentry = (PrivateKeyEntry)entry;
                        dos.writeInt(1);
                        dos.writeUTF(alias);
                        dos.writeLong(pentry.date.getTime());
                        dos.writeInt(pentry.protectedKey.length);
                        dos.write(pentry.protectedKey);
                        int chainLen = pentry.chain == null ? 0 : pentry.chain.length;
                        dos.writeInt(chainLen);
                        for (int i = 0; i < chainLen; ++i) {
                            encoded = pentry.chain[i].getEncoded();
                            dos.writeUTF(pentry.chain[i].getType());
                            dos.writeInt(encoded.length);
                            dos.write(encoded);
                        }
                        continue;
                    }
                    if (entry instanceof TrustedCertEntry) {
                        dos.writeInt(2);
                        dos.writeUTF(alias);
                        dos.writeLong(((TrustedCertEntry)entry).date.getTime());
                        encoded = ((TrustedCertEntry)entry).cert.getEncoded();
                        dos.writeUTF(((TrustedCertEntry)entry).cert.getType());
                        dos.writeInt(encoded.length);
                        dos.write(encoded);
                        continue;
                    }
                    dos.writeInt(3);
                    dos.writeUTF(alias);
                    dos.writeLong(((SecretKeyEntry)entry).date.getTime());
                    oos = new ObjectOutputStream(dos);
                    oos.writeObject(((SecretKeyEntry)entry).sealedKey);
                }
                byte[] digest = md.digest();
                dos.write(digest);
                dos.flush();
            }
            finally {
                if (oos != null) {
                    oos.close();
                } else {
                    dos.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable<String, Object> hashtable = this.entries;
        synchronized (hashtable) {
            DataInputStream dis;
            MessageDigest md = null;
            CertificateFactory cf = null;
            Hashtable<String, CertificateFactory> cfs = null;
            ByteArrayInputStream bais = null;
            byte[] encoded = null;
            if (stream == null) {
                return;
            }
            if (password != null) {
                md = this.getPreKeyedHash(password);
                dis = new DataInputStream(new DigestInputStream(stream, md));
            } else {
                dis = new DataInputStream(stream);
            }
            ObjectInputStream ois = null;
            try {
                int xMagic = dis.readInt();
                int xVersion = dis.readInt();
                if (xMagic != -825307442 && xMagic != -17957139 || xVersion != 1 && xVersion != 2) {
                    throw new IOException("Invalid keystore format");
                }
                if (xVersion == 1) {
                    cf = CertificateFactory.getInstance("X509");
                } else {
                    cfs = new Hashtable<String, CertificateFactory>(3);
                }
                this.entries.clear();
                int count = dis.readInt();
                for (int i = 0; i < count; ++i) {
                    String alias;
                    Object entry;
                    int tag = dis.readInt();
                    if (tag == 1) {
                        entry = new PrivateKeyEntry();
                        alias = dis.readUTF();
                        ((PrivateKeyEntry)entry).date = new Date(dis.readLong());
                        try {
                            ((PrivateKeyEntry)entry).protectedKey = new byte[dis.readInt()];
                        }
                        catch (OutOfMemoryError e) {
                            throw new IOException("Keysize too big");
                        }
                        dis.readFully(((PrivateKeyEntry)entry).protectedKey);
                        int numOfCerts = dis.readInt();
                        try {
                            if (numOfCerts > 0) {
                                ((PrivateKeyEntry)entry).chain = new Certificate[numOfCerts];
                            }
                        }
                        catch (OutOfMemoryError e) {
                            throw new IOException("Too many certificates in chain");
                        }
                        for (int j = 0; j < numOfCerts; ++j) {
                            if (xVersion == 2) {
                                String certType = dis.readUTF();
                                if (cfs.containsKey(certType)) {
                                    cf = (CertificateFactory)cfs.get(certType);
                                } else {
                                    cf = CertificateFactory.getInstance(certType);
                                    cfs.put(certType, cf);
                                }
                            }
                            try {
                                encoded = new byte[dis.readInt()];
                            }
                            catch (OutOfMemoryError e) {
                                throw new IOException("Certificate too big");
                            }
                            dis.readFully(encoded);
                            bais = new ByteArrayInputStream(encoded);
                            ((PrivateKeyEntry)entry).chain[j] = cf.generateCertificate(bais);
                        }
                        this.entries.put(alias, entry);
                        continue;
                    }
                    if (tag == 2) {
                        entry = new TrustedCertEntry();
                        alias = dis.readUTF();
                        ((TrustedCertEntry)entry).date = new Date(dis.readLong());
                        if (xVersion == 2) {
                            String certType = dis.readUTF();
                            if (cfs.containsKey(certType)) {
                                cf = (CertificateFactory)cfs.get(certType);
                            } else {
                                cf = CertificateFactory.getInstance(certType);
                                cfs.put(certType, cf);
                            }
                        }
                        try {
                            encoded = new byte[dis.readInt()];
                        }
                        catch (OutOfMemoryError e) {
                            throw new IOException("Certificate too big");
                        }
                        dis.readFully(encoded);
                        bais = new ByteArrayInputStream(encoded);
                        ((TrustedCertEntry)entry).cert = cf.generateCertificate(bais);
                        this.entries.put(alias, entry);
                        continue;
                    }
                    if (tag == 3) {
                        entry = new SecretKeyEntry();
                        alias = dis.readUTF();
                        ((SecretKeyEntry)entry).date = new Date(dis.readLong());
                        try {
                            ois = new ObjectInputStream(dis);
                            ((SecretKeyEntry)entry).sealedKey = (SealedObject)ois.readObject();
                        }
                        catch (ClassNotFoundException cnfe) {
                            throw new IOException(cnfe.getMessage());
                        }
                        this.entries.put(alias, entry);
                        continue;
                    }
                    throw new IOException("Unrecognized keystore entry");
                }
                if (password != null) {
                    byte[] computed = md.digest();
                    byte[] actual = new byte[computed.length];
                    dis.readFully(actual);
                    for (int i = 0; i < computed.length; ++i) {
                        if (computed[i] == actual[i]) continue;
                        throw new IOException("Keystore was tampered with, or password was incorrect");
                    }
                }
            }
            finally {
                if (ois != null) {
                    ois.close();
                } else {
                    dis.close();
                }
            }
        }
    }

    private MessageDigest getPreKeyedHash(char[] password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        int i;
        MessageDigest md = MessageDigest.getInstance("SHA");
        byte[] passwdBytes = new byte[password.length * 2];
        int j = 0;
        for (i = 0; i < password.length; ++i) {
            passwdBytes[j++] = (byte)(password[i] >> 8);
            passwdBytes[j++] = (byte)password[i];
        }
        md.update(passwdBytes);
        for (i = 0; i < passwdBytes.length; ++i) {
            passwdBytes[i] = 0;
        }
        md.update("Mighty Aphrodite".getBytes("UTF8"));
        return md;
    }

    private static final class TrustedCertEntry {
        Date date;
        Certificate cert;

        private TrustedCertEntry() {
        }
    }

    private static final class SecretKeyEntry {
        Date date;
        SealedObject sealedKey;

        private SecretKeyEntry() {
        }
    }

    private static final class PrivateKeyEntry {
        Date date;
        byte[] protectedKey;
        Certificate[] chain;

        private PrivateKeyEntry() {
        }
    }
}

