/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.nuspackage;

import com.tim.nuspacker.nuspackage.contents.Contents;
import com.tim.nuspacker.nuspackage.fst.FSTEntries;
import com.tim.nuspacker.nuspackage.interfaces.IHasData;
import com.tim.nuspacker.utils.Utils;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class FST
implements IHasData {
    private byte[] magicbytes;
    private int unknown;
    private int contentCount;
    private byte[] padding;
    private Contents contents;
    private FSTEntries fileEntries;
    private static ByteBuffer strings = ByteBuffer.allocate(0x300000);
    public static int curEntryOffset = 0;
    private byte[] alignment;

    public FST(Contents contents) {
        byte[] byArray = new byte[4];
        byArray[0] = 70;
        byArray[1] = 83;
        byArray[2] = 84;
        this.magicbytes = byArray;
        this.unknown = 32;
        this.contentCount = 0;
        this.padding = new byte[20];
        this.contents = null;
        this.fileEntries = null;
        this.alignment = null;
        this.contents = contents;
    }

    public void update() {
        strings.clear();
        curEntryOffset = 0;
        this.contents.resetFileOffsets();
        this.fileEntries.update();
        this.contents.update(this.fileEntries);
        this.fileEntries.getRootEntry().setEntryCount(this.fileEntries.getFSTEntryCount());
        this.contentCount = this.contents.getContentCount();
    }

    public static int getStringPos() {
        return strings.position();
    }

    public static void addString(String filename) {
        strings.put(filename.getBytes());
        strings.put((byte)0);
    }

    @Override
    public byte[] getAsData() {
        ByteBuffer buffer = ByteBuffer.allocate(this.getDataSize());
        buffer.put(this.magicbytes);
        buffer.putInt(this.unknown);
        buffer.putInt(this.contentCount);
        buffer.put(this.padding);
        buffer.put(this.contents.getFSTContentHeaderAsData());
        buffer.put(this.fileEntries.getAsData());
        buffer.put(Arrays.copyOfRange(strings.array(), 0, strings.position()));
        buffer.put(this.alignment);
        return buffer.array();
    }

    @Override
    public int getDataSize() {
        int size = 0;
        size += this.magicbytes.length;
        size += 4;
        size += 4;
        size += this.padding.length;
        size += this.contents.getFSTContentHeaderDataSize();
        size += this.fileEntries.getDataSize();
        int newsize = (int)Utils.align(size += strings.position(), 32768);
        this.alignment = new byte[newsize - size];
        return newsize;
    }

    public FSTEntries getFSTEntries() {
        if (this.fileEntries == null) {
            this.fileEntries = new FSTEntries();
        }
        return this.fileEntries;
    }

    public Contents getContents() {
        return this.contents;
    }
}

