/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.nuspackage;

import com.tim.nuspacker.nuspackage.FST;
import com.tim.nuspacker.nuspackage.Ticket;
import com.tim.nuspacker.nuspackage.contents.ContentInfo;
import com.tim.nuspacker.nuspackage.contents.ContentInfos;
import com.tim.nuspacker.nuspackage.contents.Contents;
import com.tim.nuspacker.nuspackage.crypto.Encryption;
import com.tim.nuspacker.nuspackage.crypto.IV;
import com.tim.nuspacker.nuspackage.crypto.Key;
import com.tim.nuspacker.nuspackage.interfaces.IHasData;
import com.tim.nuspacker.utils.AppXMLInfo;
import com.tim.nuspacker.utils.HashUtil;
import com.tim.nuspacker.utils.Utils;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;

public class TMD
implements IHasData {
    private int signatureType = 65540;
    private byte[] signature = new byte[256];
    private byte[] padding0 = new byte[60];
    private byte[] issuer = ByteBuffer.allocate(64).put(Utils.hexStringToByteArray("526F6F742D434130303030303030332D435030303030303030620000000000000000000000000000000000000000000000000000000000000000000000000000")).array();
    private byte version = 1;
    private byte CACRLVersion = 0;
    private byte signerCRLVersion = 0;
    private byte padding1 = 0;
    private long systemVersion = 1407443871481866L;
    private int titleType = 256;
    private short groupID = 0;
    private int appType = Integer.MIN_VALUE;
    private int random1 = 0;
    private int random2 = 0;
    private byte[] reserved = new byte[50];
    private int accessRights = 0;
    private short titleVersion = 0;
    private short contentCount = 0;
    private short bootIndex = 0;
    private byte[] padding3 = new byte[2];
    private byte[] SHA2 = new byte[32];
    private ContentInfos contentInfos = null;
    private Contents contents = null;
    private Ticket ticket;

    public TMD(AppXMLInfo appInfo, FST fst, Ticket ticket) {
        this.setGroupID(appInfo.getGroupID());
        this.setSystemVersion(appInfo.getOSVersion());
        this.setAppType(appInfo.getAppType());
        this.setTitleVersion(appInfo.getTitleVersion());
        this.setTicket(ticket);
        this.setContents(fst.getContents());
        this.contentInfos = new ContentInfos();
    }

    private void setContents(Contents contents) {
        if (contents != null) {
            this.contents = contents;
            this.contentCount = contents.getContentCount();
        }
    }

    public void update() {
        this.updateContents();
    }

    public void updateContents() {
        this.contentCount = this.contents.getContentCount();
        ContentInfo firstContentInfo = new ContentInfo(this.contents.getContentCount());
        byte[] randomHash = new byte[32];
        ThreadLocalRandom.current().nextBytes(randomHash);
        firstContentInfo.setSHA2Hash(HashUtil.hashSHA2(this.contents.getAsData()));
        this.getContentInfos().setContentInfo(0, firstContentInfo);
    }

    public void updateContentInfoHash() {
        this.SHA2 = HashUtil.hashSHA2(this.getContentInfos().getAsData());
    }

    @Override
    public byte[] getAsData() {
        ByteBuffer buffer = ByteBuffer.allocate(this.getDataSize());
        buffer.putInt(this.signatureType);
        buffer.put(this.signature);
        buffer.put(this.padding0);
        buffer.put(this.issuer);
        buffer.put(this.version);
        buffer.put(this.CACRLVersion);
        buffer.put(this.signerCRLVersion);
        buffer.put(this.padding1);
        buffer.putLong(this.getSystemVersion());
        buffer.putLong(this.getTicket().getTitleID());
        buffer.putInt(this.titleType);
        buffer.putShort(this.getGroupID());
        buffer.putInt(this.getAppType());
        buffer.putInt(this.random1);
        buffer.putInt(this.random2);
        buffer.put(this.reserved);
        buffer.putInt(this.accessRights);
        buffer.putShort(this.getTitleVersion());
        buffer.putShort(this.contentCount);
        buffer.putShort(this.bootIndex);
        buffer.put(this.padding3);
        buffer.put(this.SHA2);
        buffer.put(this.getContentInfos().getAsData());
        buffer.put(this.getContents().getAsData());
        return buffer.array();
    }

    @Override
    public int getDataSize() {
        int staticSize = 516;
        int contentInfoSize = this.contentInfos.getDataSize();
        int contentsSize = this.contents.getDataSize();
        return staticSize + contentInfoSize + contentsSize;
    }

    public ContentInfos getContentInfos() {
        if (this.contentInfos == null) {
            this.contentInfos = new ContentInfos();
        }
        return this.contentInfos;
    }

    public void setContentInfos(ContentInfos contentInfos) {
        this.contentInfos = contentInfos;
    }

    public Contents getContents() {
        if (this.contents == null) {
            this.contents = new Contents();
        }
        return this.contents;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public Encryption getEncryption() {
        ByteBuffer iv = ByteBuffer.allocate(16);
        iv.putLong(this.getTicket().getTitleID());
        Key key = this.getTicket().getDecryptedKey();
        return new Encryption(key, new IV(iv.array()));
    }

    public long getSystemVersion() {
        return this.systemVersion;
    }

    public void setSystemVersion(long systemVersion) {
        this.systemVersion = systemVersion;
    }

    public short getGroupID() {
        return this.groupID;
    }

    public void setGroupID(short groupID) {
        this.groupID = groupID;
    }

    public int getAppType() {
        return this.appType;
    }

    public void setAppType(int appType) {
        this.appType = appType;
    }

    public short getTitleVersion() {
        return this.titleVersion;
    }

    public void setTitleVersion(short titleVersion) {
        this.titleVersion = titleVersion;
    }
}

