/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.nuspackage;

import com.tim.nuspacker.nuspackage.crypto.Encryption;
import com.tim.nuspacker.nuspackage.crypto.IV;
import com.tim.nuspacker.nuspackage.crypto.Key;
import com.tim.nuspacker.utils.Utils;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;

public class Ticket {
    private long titleID;
    private Key decryptedKey = new Key();
    private Key encryptWith = new Key();

    public Ticket(long titleID, Key decryptedKey, Key encryptWith) {
        this.setTitleID(titleID);
        this.setDecryptedKey(decryptedKey);
        this.setEncryptWith(encryptWith);
    }

    public byte[] getAsData() {
        ByteBuffer buffer = ByteBuffer.allocate(848);
        buffer.put(Utils.hexStringToByteArray("00010004"));
        byte[] randomData = new byte[256];
        ThreadLocalRandom.current().nextBytes(randomData);
        buffer.put(randomData);
        buffer.put(new byte[60]);
        buffer.put(Utils.hexStringToByteArray("526F6F742D434130303030303030332D58533030303030303063000000000000"));
        buffer.put(new byte[92]);
        buffer.put(Utils.hexStringToByteArray("010000"));
        buffer.put(this.getEncryptedKey().getKey());
        buffer.put(Utils.hexStringToByteArray("000005"));
        randomData = new byte[6];
        ThreadLocalRandom.current().nextBytes(randomData);
        buffer.put(randomData);
        buffer.put(new byte[4]);
        buffer.putLong(this.getTitleID());
        buffer.put(Utils.hexStringToByteArray("00000011000000000000000000000005"));
        buffer.put(new byte[176]);
        buffer.put(Utils.hexStringToByteArray("00010014000000AC000000140001001400000000000000280000000100000084000000840003000000000000FFFFFF01"));
        buffer.put(new byte[124]);
        return buffer.array();
    }

    public Key getEncryptedKey() {
        ByteBuffer iv = ByteBuffer.allocate(16);
        iv.putLong(this.getTitleID());
        Encryption encrypt = new Encryption(this.getEncryptWith(), new IV(iv.array()));
        return new Key(encrypt.encrypt(this.getDecryptedKey().getKey()));
    }

    public long getTitleID() {
        return this.titleID;
    }

    public void setTitleID(long titleID) {
        this.titleID = titleID;
    }

    public Key getDecryptedKey() {
        return this.decryptedKey;
    }

    public void setDecryptedKey(Key decryptedKey) {
        this.decryptedKey = decryptedKey;
    }

    public Key getEncryptWith() {
        return this.encryptWith;
    }

    public void setEncryptWith(Key encryptWith) {
        this.encryptWith = encryptWith;
    }
}

