/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.nuspackage.contents;

import com.tim.nuspacker.nuspackage.crypto.ContentHashes;
import com.tim.nuspacker.nuspackage.crypto.Encryption;
import com.tim.nuspacker.nuspackage.fst.FSTEntry;
import com.tim.nuspacker.nuspackage.interfaces.IHasData;
import com.tim.nuspacker.nuspackage.packaging.NUSPackage;
import com.tim.nuspacker.nuspackage.packaging.NUSPackageFactory;
import com.tim.nuspacker.utils.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javafx.util.Pair;

public class Content
implements IHasData {
    public static final short TYPE_CONTENT = 8192;
    public static final short TYPE_ENCRYPTED = 1;
    public static final short TYPE_HASHED = 2;
    private int ID = 0;
    private short index = 0;
    private short type = 0;
    private long encryptedFileSize;
    private byte[] SHA2 = new byte[20];
    private long curFileOffset = 0L;
    public static final int ALIGNMENT_IN_CONTENT_FILE = 32;
    public static final int CONTENT_FILE_PADDING = 32768;
    private List<FSTEntry> entries = new ArrayList<FSTEntry>();
    private int groupID = 0;
    private long parentTitleID = 0L;
    private short entriesFlags = 0;
    private boolean isFSTContent;

    Content() {
    }

    public int getID() {
        return this.ID;
    }

    public void setID(int id) {
        this.ID = id;
    }

    public short getType() {
        return this.type;
    }

    public void addType(short type) {
        this.type = (short)(this.type | type);
    }

    public void removeType(short type) {
        this.type = (short)(this.type & ~type);
    }

    public void setType(short type) {
        this.type = type;
    }

    public short getIndex() {
        return this.index;
    }

    public void setIndex(short index) {
        this.index = index;
    }

    public long getParentTitleID() {
        return this.parentTitleID;
    }

    public void setParentTitleID(long parentTitleID) {
        this.parentTitleID = parentTitleID;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public void setGroupID(int groupID) {
        this.groupID = groupID;
    }

    private long getCurFileOffset() {
        return this.curFileOffset;
    }

    private void setCurFileOffset(long curFileOffset) {
        this.curFileOffset = curFileOffset;
    }

    public void setEncryptedFileSize(long size) {
        this.encryptedFileSize = size;
    }

    public long getEncryptedFileSize() {
        return this.encryptedFileSize;
    }

    public void setHash(byte[] hash) {
        this.SHA2 = hash;
    }

    public byte[] getHash() {
        return this.SHA2;
    }

    public boolean isHashed() {
        return (this.getType() & 2) == 2;
    }

    public boolean isFSTContent() {
        return this.isFSTContent;
    }

    public void setFSTContent(boolean isFSTContent) {
        this.isFSTContent = isFSTContent;
    }

    public void setEntriesFlags(short entriesFlag) {
        this.entriesFlags = entriesFlag;
    }

    public short getEntriesFlags() {
        return this.entriesFlags;
    }

    public int getFSTContentHeaderDataSize() {
        return 32;
    }

    public Pair<byte[], Long> getFSTContentHeaderAsData(long old_content_offset) {
        long fst_content_size;
        ByteBuffer buffer = ByteBuffer.allocate(this.getFSTContentHeaderDataSize());
        byte unkwn = 0;
        long content_offset = old_content_offset;
        long fst_content_size_written = fst_content_size = this.getEncryptedFileSize() / 32768L;
        if (this.isHashed()) {
            unkwn = 2;
            if ((fst_content_size_written -= (fst_content_size / 64L + 1L) * 2L) < 0L) {
                fst_content_size_written = 0L;
            }
        } else {
            unkwn = 1;
        }
        if (this.isFSTContent()) {
            unkwn = 0;
            if (fst_content_size == 1L) {
                fst_content_size = 0L;
            }
            content_offset += fst_content_size + 2L;
            fst_content_size = 0L;
        } else {
            content_offset += fst_content_size;
        }
        buffer.putInt((int)old_content_offset);
        buffer.putInt((int)fst_content_size_written);
        buffer.putLong(this.getParentTitleID());
        buffer.putInt(16, this.getGroupID());
        buffer.put(20, unkwn);
        return new Pair((Object)buffer.array(), (Object)content_offset);
    }

    public long getOffsetForFileAndIncrease(FSTEntry fstEntry) {
        long old_fileoffset = this.getCurFileOffset();
        this.setCurFileOffset(old_fileoffset + Utils.align(fstEntry.getFilesize(), 32));
        return old_fileoffset;
    }

    public void resetFileOffsets() {
        this.curFileOffset = 0L;
    }

    private List<FSTEntry> getFSTEntries() {
        return this.entries;
    }

    public int getFSTEntryNumber() {
        return this.entries.size();
    }

    @Override
    public byte[] getAsData() {
        ByteBuffer buffer = ByteBuffer.allocate(this.getDataSize());
        buffer.putInt(this.getID());
        buffer.putShort(this.getIndex());
        buffer.putShort(this.getType());
        buffer.putLong(this.getEncryptedFileSize());
        buffer.put(this.getHash());
        return buffer.array();
    }

    @Override
    public int getDataSize() {
        return 48;
    }

    public void packContentToFile(String outputDir) throws IOException {
        System.out.println("Packing Content " + String.format("%08X", this.getID()));
        System.out.println();
        NUSPackage nusPackage = NUSPackageFactory.getPackageByContent(this);
        Encryption encryption = nusPackage.getEncryption();
        System.out.println("Packing files into one file:");
        File decryptedFile = this.packDecrypted();
        System.out.println();
        System.out.println("Generate hashes:");
        ContentHashes contentHashes = new ContentHashes(decryptedFile, this.isHashed());
        String h3_path = String.valueOf(outputDir) + "/" + String.format("%08X", this.getID()) + ".h3";
        contentHashes.saveH3ToFile(h3_path);
        this.setHash(contentHashes.getTMDHash());
        System.out.println();
        System.out.println("Encrypt content (" + String.format("%08X", this.getID()) + ")");
        File encryptedFile = this.packEncrypted(outputDir, decryptedFile, contentHashes, encryption);
        this.setEncryptedFileSize(encryptedFile.length());
        System.out.println();
        System.out.println("Content " + String.format("%08X", this.getID()) + " packed!");
        System.out.println("-------------");
    }

    private File packEncrypted(String outputDir, File decryptedFile, ContentHashes hashes, Encryption encryption) throws IOException {
        String outputFilePath = String.format("%s/%08X.app", outputDir, this.getID());
        if ((this.getType() & 2) == 2) {
            encryption.encryptFileHashed(decryptedFile, this, outputFilePath, hashes);
        } else {
            encryption.encryptFileWithPadding(decryptedFile, this, outputFilePath, 32768);
        }
        System.out.println("Saved encrypted file to: " + outputFilePath);
        return new File(outputFilePath);
    }

    private File packDecrypted() throws IOException {
        String tmp_path = String.format("%s/%08X.dec", "tmp", this.getID());
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(tmp_path);
            int totalCount = this.getFSTEntryNumber();
            int cnt_file = 1;
            long cur_offset = 0L;
            for (FSTEntry entry : this.getFSTEntries()) {
                if (!entry.isNotInPackage()) {
                    if (entry.isFile()) {
                        if (cur_offset != entry.getFileOffset()) {
                            System.out.println("FAILED");
                        }
                        long old_offset = cur_offset;
                        String output = String.format("[%05d/%05d] Writing at %08x | FileSize: %08x | %s", cnt_file, totalCount, old_offset, entry.getFilesize(), entry.getFilename());
                        Utils.copyFileInto(entry.getFile(), fos, output);
                        int padding = (int)((cur_offset += Utils.align(entry.getFilesize(), 32)) - (old_offset + entry.getFilesize()));
                        fos.write(new byte[padding]);
                    } else {
                        System.out.println(String.format("[%05d/%05d] Wrote folder: \"%s\"", cnt_file, totalCount, entry.getFilename()));
                    }
                }
                ++cnt_file;
            }
        }
        return new File(tmp_path);
    }

    public void update(List<FSTEntry> entries) {
        if (entries != null) {
            this.entries = entries;
        }
    }

    public boolean equals(Object other) {
        boolean result;
        if (other == null || this.getClass() != other.getClass()) {
            result = false;
        } else {
            Content other_ = (Content)other;
            result = this.ID == other_.ID;
        }
        return result;
    }
}

