/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.nuspackage.contents;

import com.tim.nuspacker.nuspackage.interfaces.IHasData;
import java.nio.ByteBuffer;

public class ContentInfo
implements IHasData {
    private short indexOffset = 0;
    private short commandCount = (short)11;
    private byte[] SHA2Hash = new byte[32];

    public ContentInfo() {
        this(0);
    }

    public ContentInfo(short contentCount) {
        this(0, contentCount);
    }

    public ContentInfo(short indexOffset, short contentCount) {
        this.indexOffset = indexOffset;
        this.commandCount = contentCount;
    }

    @Override
    public byte[] getAsData() {
        ByteBuffer buffer = ByteBuffer.allocate(36);
        buffer.putShort(this.getIndexOffset());
        buffer.putShort(this.getCommandCount());
        buffer.put(this.getSHA2Hash());
        return buffer.array();
    }

    public static int getDataSizeStatic() {
        return 36;
    }

    @Override
    public int getDataSize() {
        return 36;
    }

    public short getCommandCount() {
        return this.commandCount;
    }

    public short getIndexOffset() {
        return this.indexOffset;
    }

    public void setIndexOffset(short indexOffset) {
        this.indexOffset = indexOffset;
    }

    public byte[] getSHA2Hash() {
        return this.SHA2Hash;
    }

    public void setSHA2Hash(byte[] SHA2Hash) {
        this.SHA2Hash = SHA2Hash;
    }

    public void setCommandCount(short commandCount) {
        this.commandCount = commandCount;
    }
}

