/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.nuspackage.contents;

import com.tim.nuspacker.nuspackage.contents.ContentInfo;
import com.tim.nuspacker.nuspackage.interfaces.IHasData;
import java.nio.ByteBuffer;

public class ContentInfos
implements IHasData {
    private static final int contentInfoCount = 64;
    private ContentInfo[] contentinfos = new ContentInfo[64];

    public void setContentInfo(int index, ContentInfo contentInfo) {
        if (index < 0 && index > this.contentinfos.length - 1) {
            throw new IllegalArgumentException("Error on setting ContentInfo, index " + index + " invalid");
        }
        if (contentInfo == null) {
            throw new IllegalArgumentException("Error on setting ContentInfo, ContentInfo is null");
        }
        this.contentinfos[index] = contentInfo;
    }

    public ContentInfo getContentInfo(int index) {
        if (index < 0 && index > this.contentinfos.length - 1) {
            throw new IllegalArgumentException("Error on getting ContentInfo, index " + index + " invalid");
        }
        if (this.contentinfos[index] == null) {
            this.contentinfos[index] = new ContentInfo();
        }
        return this.contentinfos[index];
    }

    @Override
    public byte[] getAsData() {
        ByteBuffer buffer = ByteBuffer.allocate(ContentInfo.getDataSizeStatic() * this.contentinfos.length);
        int i = 0;
        while (i < this.contentinfos.length - 1) {
            if (this.contentinfos[i] == null) {
                this.contentinfos[i] = new ContentInfo();
            }
            buffer.put(this.contentinfos[i].getAsData());
            ++i;
        }
        return buffer.array();
    }

    @Override
    public int getDataSize() {
        return this.contentinfos.length * ContentInfo.getDataSizeStatic();
    }
}

