/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.nuspackage.contents;

import com.tim.nuspacker.nuspackage.contents.Content;
import com.tim.nuspacker.nuspackage.crypto.Encryption;
import com.tim.nuspacker.nuspackage.fst.FSTEntries;
import com.tim.nuspacker.nuspackage.interfaces.IHasData;
import com.tim.nuspacker.nuspackage.packaging.ContentDetails;
import com.tim.nuspacker.nuspackage.packaging.NUSPackage;
import com.tim.nuspacker.nuspackage.packaging.NUSPackageFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javafx.util.Pair;

public class Contents
implements IHasData {
    private List<Content> contents = new ArrayList<Content>();
    private Content fstContent;

    public Contents() {
        this.setFSTContent(this.getNewContent());
    }

    public void setFSTContent(Content content) {
        this.fstContent = content;
        content.setFSTContent(true);
    }

    public Content getFSTContent() {
        return this.fstContent;
    }

    public Content getNewContent() {
        return this.getNewContent(false);
    }

    public Content getNewContent(boolean isHashed) {
        ContentDetails details = new ContentDetails(isHashed, 0, 0L, 0);
        return this.getNewContent(details);
    }

    public Content getNewContent(ContentDetails details) {
        Content content = new Content();
        content.setID(this.contents.size());
        content.setIndex((short)this.contents.size());
        if (details.isContent()) {
            content.addType((short)8192);
        }
        if (details.isEncrypted()) {
            content.addType((short)1);
        }
        if (details.isHashed()) {
            content.addType((short)2);
        }
        content.setEntriesFlags(details.getEntriesFlag());
        content.setGroupID(details.getGroupID());
        content.setParentTitleID(details.getParentTitleID());
        this.getContents().add(content);
        return content;
    }

    public short getContentCount() {
        return (short)this.getContents().size();
    }

    @Override
    public byte[] getAsData() {
        ByteBuffer buffer = ByteBuffer.allocate(this.getDataSize());
        for (Content c : this.getContents()) {
            buffer.put(c.getAsData());
        }
        return buffer.array();
    }

    @Override
    public int getDataSize() {
        int size = 0;
        for (Content c : this.getContents()) {
            size += c.getDataSize();
        }
        return size;
    }

    public byte[] getFSTContentHeaderAsData() {
        long content_offset = 0L;
        ByteBuffer buffer = ByteBuffer.allocate(this.getFSTContentHeaderDataSize());
        for (Content c : this.getContents()) {
            Pair<byte[], Long> result = c.getFSTContentHeaderAsData(content_offset);
            buffer.put((byte[])result.getKey());
            content_offset = (Long)result.getValue();
        }
        return buffer.array();
    }

    public int getFSTContentHeaderDataSize() {
        int size = 0;
        for (Content c : this.getContents()) {
            size += c.getFSTContentHeaderDataSize();
        }
        return size;
    }

    public List<Content> getContents() {
        if (this.contents == null) {
            this.contents = new ArrayList<Content>();
        }
        return this.contents;
    }

    public void resetFileOffsets() {
        for (Content c : this.getContents()) {
            c.resetFileOffsets();
        }
    }

    public void update(FSTEntries fileEntries) {
        for (Content c : this.getContents()) {
            c.update(fileEntries.getFSTEntriesByContent(c));
        }
    }

    public void packContents(String outputDir) throws IOException {
        for (Content c : this.getContents()) {
            if (c.equals(this.getFSTContent())) continue;
            c.packContentToFile(outputDir);
        }
        NUSPackage nuspackage = NUSPackageFactory.getPackageByContents(this);
        Encryption encryption = nuspackage.getEncryption();
        System.out.println("Packing the FST into " + String.format("%08X", this.fstContent.getID()) + ".");
        String fst_path = String.valueOf(outputDir) + "/" + String.format("%08X.app", this.fstContent.getID());
        encryption.encryptFileWithPadding(nuspackage.getFST(), fst_path, (short)this.getFSTContent().getID(), 32768);
        System.out.println("-------------");
        System.out.println("Packed all contents.\n\n");
    }

    public void deleteContent(Content cur_content) {
        this.contents.remove(cur_content);
    }
}

