/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.nuspackage.crypto;

import com.tim.nuspacker.utils.ByteArrayBuffer;
import com.tim.nuspacker.utils.HashUtil;
import com.tim.nuspacker.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;

public class ContentHashes {
    Map<Integer, byte[]> h0hashes = new TreeMap<Integer, byte[]>();
    Map<Integer, byte[]> h1hashes = new TreeMap<Integer, byte[]>();
    Map<Integer, byte[]> h2hashes = new TreeMap<Integer, byte[]>();
    Map<Integer, byte[]> h3hashes = new TreeMap<Integer, byte[]>();
    byte[] TMDHash = new byte[20];
    private int blockCount = 0;

    public ContentHashes(File file, boolean hashed) {
        if (hashed) {
            try {
                this.calculateH0Hashes(file);
                this.calculateOtherHashes(1, this.h0hashes, this.h1hashes);
                this.calculateOtherHashes(2, this.h1hashes, this.h2hashes);
                this.calculateOtherHashes(3, this.h2hashes, this.h3hashes);
                this.setTMDHash(HashUtil.hashSHA1(this.getH3Hashes()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.setTMDHash(HashUtil.hashSHA1(file, 32768));
        }
    }

    private void calculateOtherHashes(int hash_level, Map<Integer, byte[]> in_hashes, Map<Integer, byte[]> out_hashes) throws Exception {
        int hash_level_pow = (int)Math.pow(16.0, hash_level);
        int hashescount = this.blockCount / hash_level_pow + 1;
        int new_blocks = 0;
        int j = 0;
        while (j < hashescount) {
            byte[] cur_hashes = new byte[320];
            int i = j * 16;
            while (i < j * 16 + 16) {
                if (in_hashes.containsKey(i)) {
                    byte[] cur_hash = in_hashes.get(i);
                    System.arraycopy(cur_hash, 0, cur_hashes, i % 16 * 20, 20);
                } else {
                    System.arraycopy(new byte[20], 0, cur_hashes, i % 16 * 20, 20);
                }
                ++i;
            }
            out_hashes.put(new_blocks, HashUtil.hashSHA1(cur_hashes));
            int progress = (int)((double)(++new_blocks) * 1.0 / (double)hashescount * 1.0 * 100.0);
            if (new_blocks % 100 == 0) {
                System.out.print("\rcalculating h" + hash_level + ": " + progress + "%");
            }
            ++j;
        }
        System.out.println("\rcalculating h" + hash_level + ": done");
    }

    private void calculateH0Hashes(File file) throws IOException {
        int read;
        FileInputStream in = new FileInputStream(file);
        int buffer_size = 64512;
        byte[] buffer = new byte[buffer_size];
        ByteArrayBuffer overflowbuffer = new ByteArrayBuffer(buffer_size);
        int block = 0;
        int total_blocks = (int)(file.length() / (long)buffer_size) + 1;
        do {
            if ((read = Utils.getChunkFromStream(in, buffer, overflowbuffer, buffer_size)) != buffer_size) {
                ByteBuffer new_buffer = ByteBuffer.allocate(buffer_size);
                new_buffer.put(buffer);
                buffer = new_buffer.array();
            }
            this.h0hashes.put(block, HashUtil.hashSHA1(buffer));
            int progress = (int)((double)(++block) * 1.0 / (double)total_blocks * 1.0 * 100.0);
            if (block % 100 != 0) continue;
            System.out.print("\rcalculating h0: " + progress + "%");
        } while (read == buffer_size);
        System.out.println("\rcalculating h0: done");
        this.setBlockCount(block);
    }

    public byte[] getHashForBlock(int block) throws Exception {
        if (block > this.blockCount) {
            throw new Exception("fofof");
        }
        ByteBuffer hashes = ByteBuffer.allocate(1024);
        int h0_hash_start = block / 16 * 16;
        int i = 0;
        while (i < 16) {
            int index = h0_hash_start + i;
            if (this.h0hashes.containsKey(index)) {
                hashes.put(this.h0hashes.get(index));
            } else {
                hashes.put(new byte[20]);
            }
            ++i;
        }
        int h1_hash_start = block / 256 * 16;
        int i2 = 0;
        while (i2 < 16) {
            int index = h1_hash_start + i2;
            if (this.h1hashes.containsKey(index)) {
                hashes.put(this.h1hashes.get(index));
            } else {
                hashes.put(new byte[20]);
            }
            ++i2;
        }
        int h2_hash_start = block / 4096 * 16;
        int i3 = 0;
        while (i3 < 16) {
            int index = h2_hash_start + i3;
            if (this.h2hashes.containsKey(index)) {
                hashes.put(this.h2hashes.get(index));
            } else {
                hashes.put(new byte[20]);
            }
            ++i3;
        }
        return hashes.array();
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public void setBlockCount(int blockCount) {
        this.blockCount = blockCount;
    }

    public byte[] getH3Hashes() {
        ByteBuffer buffer = ByteBuffer.allocate(this.h3hashes.size() * 20);
        int i = 0;
        while (i < this.h3hashes.size()) {
            buffer.put(this.h3hashes.get(i));
            ++i;
        }
        return buffer.array();
    }

    public byte[] getTMDHash() {
        return this.TMDHash;
    }

    public void setTMDHash(byte[] TMDHash) {
        this.TMDHash = TMDHash;
    }

    public void saveH3ToFile(String h3_path) throws IOException {
        if (!this.h3hashes.isEmpty()) {
            try (FileOutputStream fos = null;){
                fos = new FileOutputStream(h3_path);
                fos.write(this.getH3Hashes());
            }
        }
    }
}

