/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.nuspackage.crypto;

import com.tim.nuspacker.nuspackage.FST;
import com.tim.nuspacker.nuspackage.contents.Content;
import com.tim.nuspacker.nuspackage.crypto.ContentHashes;
import com.tim.nuspacker.nuspackage.crypto.IV;
import com.tim.nuspacker.nuspackage.crypto.Key;
import com.tim.nuspacker.utils.ByteArrayBuffer;
import com.tim.nuspacker.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Encryption {
    private Key key = new Key();
    private IV IV = new IV();
    private Cipher cipher = null;

    public Encryption(Key key, IV IV2) {
        try {
            this.cipher = Cipher.getInstance("AES/CBC/NoPadding", "SunJCE");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        this.init(key, IV2);
    }

    public void init(IV IV2) {
        this.init(this.getKey(), IV2);
    }

    public void init(Key key) {
        this.init(key, new IV());
    }

    public void init(Key key, IV IV2) {
        this.setKey(key);
        this.setIV(IV2);
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.getKey().getKey(), "AES");
        try {
            this.cipher.init(1, (java.security.Key)secretKeySpec, new IvParameterSpec(this.getIV().getIV()));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    public void encryptFileWithPadding(FST fst, String output_filename, short contentID, int BLOCKSIZE) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(fst.getAsData());
        FileOutputStream out = new FileOutputStream(output_filename);
        IV iv = new IV(ByteBuffer.allocate(16).putShort(contentID).array());
        this.encryptSingleFile(in, out, fst.getDataSize(), iv, BLOCKSIZE);
    }

    public void encryptFileWithPadding(File file, Content content, String output_filename, int BLOCKSIZE) throws IOException {
        FileInputStream in = new FileInputStream(file);
        FileOutputStream out = new FileOutputStream(output_filename);
        IV iv = new IV(ByteBuffer.allocate(16).putShort((short)content.getID()).array());
        this.encryptSingleFile(in, out, file.length(), iv, BLOCKSIZE);
    }

    public void encryptSingleFile(InputStream in, OutputStream out, long length, IV iv, int BLOCKSIZE) throws IOException {
        int inBlockBufferRead;
        long inputSize = length;
        long targetSize = Utils.align(inputSize, BLOCKSIZE);
        byte[] blockBuffer = new byte[BLOCKSIZE];
        long cur_position = 0L;
        ByteArrayBuffer overflow = new ByteArrayBuffer(BLOCKSIZE);
        boolean first = true;
        do {
            if (first) {
                first = false;
            } else {
                iv = null;
            }
            if (cur_position + (long)BLOCKSIZE > inputSize) {
                long expectedSize = inputSize - cur_position;
                ByteBuffer buffer = ByteBuffer.allocate(BLOCKSIZE);
                inBlockBufferRead = Utils.getChunkFromStream(in, blockBuffer, overflow, expectedSize);
                buffer.put(Arrays.copyOfRange(blockBuffer, 0, inBlockBufferRead));
                blockBuffer = buffer.array();
                inBlockBufferRead = BLOCKSIZE;
            } else {
                int expectedSize = BLOCKSIZE;
                inBlockBufferRead = Utils.getChunkFromStream(in, blockBuffer, overflow, expectedSize);
            }
            byte[] output = this.encryptChunk(blockBuffer, inBlockBufferRead, iv);
            this.setIV(new IV(Arrays.copyOfRange(output, BLOCKSIZE - 16, BLOCKSIZE)));
            out.write(output, 0, inBlockBufferRead);
        } while ((cur_position += (long)inBlockBufferRead) < targetSize && inBlockBufferRead == BLOCKSIZE);
    }

    public void encryptFileHashed(File file, Content content, String output_filename, ContentHashes hashes) throws IOException {
        File input = file;
        String output = output_filename;
        FileInputStream in = new FileInputStream(file);
        FileOutputStream out = new FileOutputStream(output);
        this.encryptFileHashed(in, out, input.length(), content, hashes);
        content.setEncryptedFileSize((int)new File(output).length());
    }

    private void encryptFileHashed(InputStream in, OutputStream out, long length, Content content, ContentHashes hashes) throws IOException {
        int read;
        int HASHBLOCKSIZE;
        int BLOCKSIZE = 65536;
        int buffer_size = HASHBLOCKSIZE = 64512;
        byte[] buffer = new byte[buffer_size];
        ByteArrayBuffer overflowbuffer = new ByteArrayBuffer(buffer_size);
        int block = 0;
        int totalblocks = (int)(length / (long)HASHBLOCKSIZE);
        do {
            byte[] output;
            if ((read = Utils.getChunkFromStream(in, buffer, overflowbuffer, buffer_size)) != buffer_size) {
                ByteBuffer new_buffer = ByteBuffer.allocate(buffer_size);
                new_buffer.put(buffer);
                buffer = new_buffer.array();
            }
            if ((output = this.encryptChunkHashed(buffer, block, hashes, content.getID())).length != BLOCKSIZE) {
                System.out.println("WTF?");
            }
            out.write(output);
            int progress = (int)((double)(++block) * 1.0 / (double)totalblocks * 1.0 * 100.0);
            if (block % 100 != 0) continue;
            System.out.print("\rEncryption: " + progress + "%");
        } while (read == buffer_size);
        System.out.println("\rEncryption: 100%");
        in.close();
        out.close();
    }

    private byte[] encryptChunkHashed(byte[] buffer, int block, ContentHashes hashes, int content_id) {
        IV iv = new IV(ByteBuffer.allocate(16).putShort((short)content_id).array());
        byte[] decryptedHashes = null;
        try {
            decryptedHashes = hashes.getHashForBlock(block);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        decryptedHashes[1] = (byte)(decryptedHashes[1] ^ (byte)content_id);
        byte[] encryptedhashes = this.encryptChunk(decryptedHashes, 1024, iv);
        decryptedHashes[1] = (byte)(decryptedHashes[1] ^ (byte)content_id);
        int iv_start = block % 16 * 20;
        iv = new IV(Arrays.copyOfRange(decryptedHashes, iv_start, iv_start + 16));
        byte[] encryptedContent = this.encryptChunk(buffer, 64512, iv);
        ByteBuffer output = ByteBuffer.allocate(65536);
        output.put(encryptedhashes);
        output.put(encryptedContent);
        return output.array();
    }

    public byte[] encryptChunk(byte[] blockBuffer, int BLOCKSIZE, IV IV2) {
        return this.encryptChunk(blockBuffer, 0, BLOCKSIZE, IV2);
    }

    public byte[] encryptChunk(byte[] blockBuffer, int offset, int BLOCKSIZE, IV IV2) {
        if (IV2 != null) {
            this.setIV(IV2);
        }
        this.init(this.getIV());
        byte[] output = this.encrypt(blockBuffer, offset, BLOCKSIZE);
        return output;
    }

    public byte[] encrypt(byte[] input) {
        return this.encrypt(input, input.length);
    }

    public byte[] encrypt(byte[] input, int len) {
        return this.encrypt(input, 0, len);
    }

    public byte[] encrypt(byte[] input, int offset, int len) {
        try {
            return this.cipher.doFinal(input, offset, len);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            e.printStackTrace();
            System.exit(2);
            return input;
        }
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public IV getIV() {
        return this.IV;
    }

    public void setIV(IV iv) {
        this.IV = iv;
    }
}

