/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.nuspackage.fst;

import com.tim.nuspacker.nuspackage.FST;
import com.tim.nuspacker.nuspackage.contents.Content;
import com.tim.nuspacker.nuspackage.fst.FSTEntry;
import com.tim.nuspacker.nuspackage.interfaces.IHasData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class FSTEntries
implements IHasData {
    private List<FSTEntry> entries = new ArrayList<FSTEntry>();

    public FSTEntries() {
        FSTEntry root = new FSTEntry(true);
        this.entries.add(root);
    }

    public List<FSTEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<FSTEntry>();
        }
        return this.entries;
    }

    public boolean isEmtpy() {
        return this.entries.isEmpty();
    }

    public boolean addEntry(FSTEntry entry) {
        if (!entry.isDir()) {
            System.out.println("FSTEntries in root need to be directories.");
            return false;
        }
        this.getEntries().add(entry);
        return true;
    }

    public void update() {
        for (FSTEntry entry : this.getEntries()) {
            entry.update();
        }
        this.updateDirRefs();
    }

    public List<FSTEntry> getFSTEntriesByContent(Content content) {
        ArrayList<FSTEntry> result = new ArrayList<FSTEntry>();
        for (FSTEntry curEntry : this.getEntries()) {
            if (curEntry.isNotInPackage()) continue;
            result.addAll(curEntry.getFSTEntriesByContent(content));
        }
        return result;
    }

    public int getFSTEntryCount() {
        int count = 0;
        for (FSTEntry entry : this.getEntries()) {
            count += entry.getEntryCount();
        }
        return count;
    }

    @Override
    public byte[] getAsData() {
        ByteBuffer buffer = ByteBuffer.allocate(this.getDataSize());
        for (FSTEntry entry : this.getEntries()) {
            buffer.put(entry.getAsData());
        }
        return buffer.array();
    }

    @Override
    public int getDataSize() {
        return this.getFSTEntryCount() * 16;
    }

    public FSTEntry getRootEntry() {
        List<FSTEntry> entries = this.getEntries();
        if (entries.size() == 0) {
            return null;
        }
        return entries.get(0);
    }

    public void updateDirRefs() {
        List<FSTEntry> entries = this.getEntries();
        if (entries.size() == 0) {
            return;
        }
        FSTEntry root = entries.get(0);
        root.setParentOffset(0);
        root.setNextOffset(FST.curEntryOffset);
        FSTEntry lastdir = root.updateDirRefs();
        if (lastdir != null) {
            lastdir.setNextOffset(FST.curEntryOffset);
        }
    }
}

