/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.nuspackage.fst;

import com.tim.nuspacker.nuspackage.FST;
import com.tim.nuspacker.nuspackage.contents.Content;
import com.tim.nuspacker.nuspackage.interfaces.IHasData;
import com.tim.nuspacker.utils.HashUtil;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class FSTEntry
implements IHasData,
Cloneable {
    private File file;
    private String filename = "";
    private FSTEntry parent = null;
    private List<FSTEntry> children = null;
    private int nameOffset = 0;
    private int entryOffset = 0;
    private short flags;
    private boolean isDir = false;
    private int parentOffset = 0;
    private int nextOffset = 0;
    private long filesize = 0L;
    private long fileoffset = 0L;
    private boolean isRoot = false;
    private int root_entryCount = 0;
    private Content content = null;
    private byte[] decryptedSHA1 = new byte[20];
    private boolean bigFile = false;
    private boolean hashedFile = false;
    private boolean notInPackage = false;

    public FSTEntry(File file) {
        this(file, false);
    }

    public FSTEntry(File file, boolean notInPackage) {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("Couldn't create FSTEntry, file is NULL or doesn't exist");
        }
        this.file = new File(file.getAbsolutePath());
        this.setDir(file.isDirectory());
        this.setFileName(file.getName());
        this.setFileSize(file.length());
        this.setNotInPackage(notInPackage);
        if (this.isFile()) {
            this.decryptedSHA1 = null;
        }
    }

    public FSTEntry(boolean root) {
        this.file = null;
        if (root) {
            this.setIsRoot(true);
            this.setDir(true);
        }
    }

    public void addChildren(FSTEntry fstEntry) {
        this.getChildren().add(fstEntry);
        fstEntry.setParent(this);
    }

    public boolean isNotInPackage() {
        return this.notInPackage;
    }

    public void setNotInPackage(boolean notInPackage) {
        this.notInPackage = notInPackage;
    }

    public FSTEntry getParent() {
        return this.parent;
    }

    private void setParent(FSTEntry child) {
        this.parent = child;
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.setFlags(content.getEntriesFlags());
        this.content = content;
    }

    public void setContentRecursive(Content content) {
        this.setContent(content);
        for (FSTEntry entry : this.getChildren()) {
            entry.setContentRecursive(content);
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    public long getFilesize() {
        if (!this.isFile()) {
            return 0L;
        }
        return this.filesize;
    }

    public void setFileSize(long filesize) {
        this.filesize = filesize;
    }

    public long getFileOffset() {
        return this.fileoffset;
    }

    public void setFileOffset(long fileOffset) {
        this.fileoffset = fileOffset;
    }

    private void setIsRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setDir(boolean isDir) {
        this.isDir = isDir;
    }

    public boolean isDir() {
        return this.isDir;
    }

    public boolean isFile() {
        return !this.isDir() && !this.isNotInPackage();
    }

    public boolean isBigFile() {
        return this.bigFile;
    }

    public void setBigFile(boolean bigFile) {
        this.bigFile = bigFile;
    }

    public boolean isHashedFile() {
        return this.hashedFile;
    }

    public void setHashedFile(boolean hashedFile) {
        this.hashedFile = hashedFile;
    }

    public byte getType() {
        byte type = 0;
        if (this.isDir()) {
            type = (byte)(type | Types.DIR.getValue());
        }
        if (this.isNotInPackage()) {
            type = (byte)(type | Types.notInNUS.getValue());
        }
        return type;
    }

    public short getFlags() {
        return this.flags;
    }

    public FSTEntry getEntryByName(String name) {
        FSTEntry result = null;
        for (FSTEntry f : this.getChildren()) {
            if (!f.getFilename().equals(name)) continue;
            result = f;
            break;
        }
        return result;
    }

    @Override
    public byte[] getAsData() {
        ByteBuffer buffer = ByteBuffer.allocate(this.getDataSize());
        if (this.isRoot()) {
            buffer.put((byte)1);
            buffer.put(new byte[7]);
            buffer.putInt(this.root_entryCount);
            buffer.put(new byte[4]);
        } else {
            buffer.put(this.getType());
            buffer.put((byte)(this.nameOffset >> 16 & 0xFF));
            buffer.putShort((short)(this.nameOffset & 0xFFFF));
            if (this.isDir()) {
                buffer.putInt(this.parentOffset);
                buffer.putInt(this.nextOffset);
            } else if (this.isFile()) {
                buffer.putInt((int)(this.fileoffset >> 5));
                buffer.putInt((int)this.filesize);
            } else if (this.isNotInPackage()) {
                buffer.putInt(0);
                buffer.putInt((int)this.filesize);
            }
            buffer.putShort(this.getFlags());
            buffer.putShort((short)this.content.getID());
        }
        if (this.children != null) {
            for (FSTEntry entry : this.getChildren()) {
                buffer.put(entry.getAsData());
            }
        }
        return buffer.array();
    }

    @Override
    public int getDataSize() {
        int size = 16;
        for (FSTEntry entry : this.getChildren()) {
            size += entry.getDataSize();
        }
        return size;
    }

    public byte[] getDecryptedHash() {
        if (this.decryptedSHA1 == null) {
            this.calculateDecryptedHash();
        }
        return this.decryptedSHA1;
    }

    public void setNameOffset(int offset) {
        if (offset > 0xFFFFFF) {
            System.out.println("Warning, filename offset is too big. Maximum is 16777215 tried to set to" + offset);
        }
        this.nameOffset = offset;
    }

    public void update() {
        this.setNameOffset(FST.getStringPos());
        FST.addString(this.filename);
        this.setEntryOffset(FST.curEntryOffset);
        ++FST.curEntryOffset;
        if (this.isDir() && !this.isRoot()) {
            this.setParentOffset(this.getParent().getEntryOffset());
        }
        if (this.getContent() != null && this.isFile()) {
            long fileoffset = this.getContent().getOffsetForFileAndIncrease(this);
            this.setFileOffset(fileoffset);
        }
        for (FSTEntry entry : this.getChildren()) {
            entry.update();
        }
    }

    public FSTEntry updateDirRefs() {
        if (!this.isDir() && !this.isRoot()) {
            return null;
        }
        if (this.parent != null) {
            this.setParentOffset(this.getParent().getEntryOffset());
        }
        FSTEntry result = null;
        int i = 0;
        while (i < this.getDirChildren().size()) {
            FSTEntry cur_result;
            FSTEntry cur_dir = this.getDirChildren().get(i);
            if (i + 1 < this.getDirChildren().size()) {
                cur_dir.setNextOffset(this.getDirChildren().get((int)(i + 1)).entryOffset);
            }
            if ((cur_result = cur_dir.updateDirRefs()) != null) {
                FSTEntry cur_foo = cur_result.getParent();
                while (cur_foo.getNextOffset() == 0) {
                    cur_foo = cur_foo.getParent();
                }
                cur_result.setNextOffset(cur_foo.getNextOffset());
            }
            if (i + 1 >= this.getDirChildren().size()) {
                result = cur_dir;
            }
            ++i;
        }
        return result;
    }

    private int getNextOffset() {
        return this.nextOffset;
    }

    public void setEntryOffset(int entryOffset) {
        this.entryOffset = entryOffset;
    }

    public int getEntryOffset() {
        return this.entryOffset;
    }

    public void setNextOffset(int nextOffset) {
        this.nextOffset = nextOffset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isDir()) {
            sb.append("DIR: ").append("\n");
        }
        if (this.isDir()) {
            sb.append("Filename: ").append(this.getFilename()).append("\n");
        }
        if (this.isDir()) {
            sb.append("       ID:").append(this.getEntryOffset()).append("\n");
        }
        if (this.isDir()) {
            sb.append(" ParentID:").append(this.parentOffset).append("\n");
        }
        if (this.isDir()) {
            sb.append("   NextID:").append(this.nextOffset).append("\n");
        }
        for (FSTEntry e : this.getChildren()) {
            sb.append(e.toString());
        }
        return sb.toString();
    }

    public void printRecursive(int space) {
        int i = 0;
        while (i < space) {
            System.out.print(" ");
            ++i;
        }
        System.out.print(this.getFilename());
        if (this.isNotInPackage()) {
            System.out.print(" (not in package)");
        }
        System.out.println();
        for (FSTEntry child : this.getDirChildren(true)) {
            child.printRecursive(space + 1);
        }
        for (FSTEntry child : this.getFileChildren(true)) {
            child.printRecursive(space + 1);
        }
    }

    public List<FSTEntry> getFSTEntriesByContent(Content content) {
        ArrayList<FSTEntry> entries = new ArrayList<FSTEntry>();
        if (this.content == null) {
            if (this.isDir) {
                System.err.println("The folder \"" + this.getFilename() + "\" is emtpy. Please add a dummy file to it.");
            } else {
                System.err.println("The file \"" + this.getFilename() + "\" is not assigned to any content (.app).");
                System.err.println("Please delete it or write a corresponding content rule");
            }
            System.exit(0);
        } else if (this.content.equals(content)) {
            entries.add(this);
        }
        for (FSTEntry child : this.getChildren()) {
            entries.addAll(child.getFSTEntriesByContent(content));
        }
        return entries;
    }

    public List<FSTEntry> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<FSTEntry>();
        }
        return this.children;
    }

    public int getEntryCount() {
        int count = 1;
        for (FSTEntry entry : this.getChildren()) {
            count += entry.getEntryCount();
        }
        return count;
    }

    public void setParentOffset(int i) {
        this.parentOffset = i;
    }

    public void setEntryCount(int fstEntryCount) {
        this.root_entryCount = fstEntryCount;
    }

    public List<FSTEntry> getDirChildren() {
        return this.getDirChildren(false);
    }

    public List<FSTEntry> getDirChildren(boolean all) {
        ArrayList<FSTEntry> result = new ArrayList<FSTEntry>();
        for (FSTEntry child : this.getChildren()) {
            if (!child.isDir() || !all && child.isNotInPackage()) continue;
            result.add(child);
        }
        return result;
    }

    public List<FSTEntry> getFileChildren() {
        return this.getFileChildren(false);
    }

    public List<FSTEntry> getFileChildren(boolean all) {
        ArrayList<FSTEntry> result = new ArrayList<FSTEntry>();
        for (FSTEntry child : this.getChildren()) {
            if (!child.isFile() && (!all || child.isDir())) continue;
            result.add(child);
        }
        return result;
    }

    public void calculateDecryptedHash() {
        this.decryptedSHA1 = HashUtil.hashSHA1(this.file, 32768);
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public FSTEntry clone() {
        try {
            return (FSTEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static enum Flags {
        NOBIGFILE(4),
        HASHED(1024);

        private final short type;

        private Flags(short type) {
            this.type = type;
        }

        public short getValue() {
            return this.type;
        }
    }

    public static enum Types {
        DIR(1),
        notInNUS(-128);

        private final byte type;

        private Types(byte type) {
            this.type = type;
        }

        public byte getValue() {
            return this.type;
        }
    }
}

