/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.nuspackage.packaging;

import com.tim.nuspacker.nuspackage.interfaces.IContentRule;
import com.tim.nuspacker.nuspackage.packaging.ContentDetails;
import java.util.ArrayList;
import java.util.List;

public class ContentRules {
    public List<ContentRule> rules = new ArrayList<ContentRule>();

    public List<ContentRule> getRules() {
        return this.rules;
    }

    public ContentRule addRule(ContentRule rule) {
        if (!this.rules.contains(rule)) {
            this.rules.add(rule);
        }
        return rule;
    }

    public ContentRule createNewRule(String pattern, ContentDetails details, boolean contentPerMatch) {
        ContentRule newRule = new ContentRule(pattern, details, contentPerMatch);
        this.rules.add(newRule);
        return newRule;
    }

    public ContentRule createNewRule(String pattern, ContentDetails details) {
        return this.createNewRule(pattern, details, false);
    }

    public static ContentRules getCommonRules(short contentGroup, long titleID) {
        ContentRules rules = new ContentRules();
        ContentDetails common_details_code = new ContentDetails(false, 0, 0L, 0);
        rules.createNewRule("/code/app.xml", common_details_code);
        rules.createNewRule("/code/cos.xml", common_details_code);
        ContentDetails common_details_meta = new ContentDetails(true, 1024, 0L, 64);
        rules.createNewRule("/meta/meta.xml", common_details_meta);
        common_details_meta = new ContentDetails(true, 1024, 0L, 64);
        rules.createNewRule("/meta/.*[^.xml)]+", common_details_meta);
        common_details_meta = new ContentDetails(true, 1024, 0L, 64);
        rules.createNewRule("/meta/bootMovie.h264", common_details_meta);
        rules.createNewRule("/meta/bootLogoTex.tga", common_details_meta);
        ContentDetails common_details_meta_manual = new ContentDetails(true, 1024, 0L, 64);
        rules.createNewRule("/meta/Manual.bfma", common_details_meta_manual);
        ContentDetails common_details_meta_images = new ContentDetails(true, 1024, 0L, 64);
        rules.createNewRule("/meta/.*.jpg", common_details_meta_images);
        rules.createNewRule("/code/.*(.rpx|.rpl)", common_details_code, true);
        ContentDetails common_details_preload = new ContentDetails(true, 0, 0L, 0);
        rules.createNewRule("/code/preload.txt", common_details_preload);
        ContentDetails common_details_content = new ContentDetails(true, contentGroup, titleID, 1024);
        rules.createNewRule("/content/.*", common_details_content);
        return rules;
    }

    private class ContentRule
    implements IContentRule {
        private String pattern = "";
        private ContentDetails details = null;
        private boolean contentPerMatch = false;

        public ContentRule(String pattern, ContentDetails details, boolean contentPerMatch) {
            this.setPattern(pattern);
            this.setDetails(details);
            this.setContentPerMatch(contentPerMatch);
        }

        @Override
        public String getPattern() {
            return this.pattern;
        }

        @Override
        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public ContentDetails getDetails() {
            return this.details;
        }

        @Override
        public void setDetails(ContentDetails details) {
            this.details = details;
        }

        @Override
        public boolean isContentPerMatch() {
            return this.contentPerMatch;
        }

        @Override
        public void setContentPerMatch(boolean contentPerMatch) {
            this.contentPerMatch = contentPerMatch;
        }
    }
}

