/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.nuspackage.packaging;

import com.tim.nuspacker.nuspackage.contents.Content;
import com.tim.nuspacker.nuspackage.contents.Contents;
import com.tim.nuspacker.nuspackage.fst.FSTEntry;
import com.tim.nuspacker.nuspackage.interfaces.IContentRule;
import com.tim.nuspacker.nuspackage.packaging.ContentDetails;
import com.tim.nuspacker.nuspackage.packaging.ContentRules;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentRulesService {
    public static long MAX_CONTENT_LENGTH = 0xBB333332L;
    public static long cur_content_size = 0L;
    public static Content cur_content = null;
    public static Content cur_content_first = null;

    public static void applyRules(FSTEntry root, Contents targetContents, ContentRules rules) {
        System.out.println("-----");
        for (IContentRule iContentRule : rules.getRules()) {
            System.out.println("Apply rule " + iContentRule.getPattern());
            if (iContentRule.isContentPerMatch()) {
                ContentRulesService.setNewContentRecursiveRule("", iContentRule.getPattern(), root, targetContents, iContentRule);
            } else {
                cur_content_first = cur_content = targetContents.getNewContent(iContentRule.getDetails());
                cur_content_size = 0L;
                boolean result = ContentRulesService.setContentRecursiveRule("", iContentRule.getPattern(), root, targetContents, iContentRule.getDetails());
                if (!result) {
                    System.out.println("No file matched the rule. Lets delete the content again");
                    targetContents.deleteContent(cur_content);
                }
                cur_content_first = null;
            }
            System.out.println("-----");
        }
    }

    private static Content setNewContentRecursiveRule(String path, String pattern, FSTEntry cur_entry, Contents targetContents, IContentRule rule) {
        String filePath;
        Matcher m;
        path = String.valueOf(path) + cur_entry.getFilename() + "/";
        Pattern p = Pattern.compile(pattern);
        Content result = null;
        if (cur_entry.getChildren().size() == 0 && (m = p.matcher(filePath = path)).matches()) {
            Content result_content;
            result = result_content = targetContents.getNewContent(rule.getDetails());
        }
        for (FSTEntry child : cur_entry.getChildren()) {
            if (child.isDir()) {
                Content child_result = ContentRulesService.setNewContentRecursiveRule(path, pattern, child, targetContents, rule);
                if (child_result == null) continue;
                result = child_result;
                continue;
            }
            String filePath2 = String.valueOf(path) + child.getFilename();
            Matcher m2 = p.matcher(filePath2);
            if (!m2.matches()) continue;
            Content result_content = targetContents.getNewContent(rule.getDetails());
            if (!child.isNotInPackage()) {
                System.out.println("Set content to " + String.format("%08X", result_content.getID()) + " for: " + filePath2);
            }
            child.setContent(result_content);
            result = result_content;
        }
        if (result != null) {
            cur_entry.setContent(result);
        }
        return result;
    }

    private static boolean setContentRecursiveRule(String path, String pattern, FSTEntry cur_entry, Contents targetContents, ContentDetails contentDetails) {
        path = String.valueOf(path) + cur_entry.getFilename() + "/";
        Pattern p = Pattern.compile(pattern);
        boolean result = false;
        if (cur_entry.getChildren().size() == 0) {
            String filePath = path;
            Matcher m = p.matcher(filePath);
            if (m.matches()) {
                if (!cur_entry.isNotInPackage()) {
                    System.out.println("Set content to " + String.format("%08X (%08X,%08X)", cur_content.getID(), cur_content_size, cur_entry.getFilesize()) + " for: " + filePath);
                }
                if (cur_entry.getChildren().isEmpty()) {
                    cur_entry.setContent(cur_content);
                }
                return true;
            }
            return false;
        }
        for (FSTEntry child : cur_entry.getChildren()) {
            if (child.isDir()) {
                boolean child_result = ContentRulesService.setContentRecursiveRule(path, pattern, child, targetContents, contentDetails);
                if (!child_result) continue;
                cur_entry.setContent(cur_content_first);
                result = true;
                continue;
            }
            String filePath = String.valueOf(path) + child.getFilename();
            Matcher m = p.matcher(filePath);
            if (!m.matches()) continue;
            if (cur_content_size > 0L && cur_content_size + child.getFilesize() > MAX_CONTENT_LENGTH) {
                System.out.println("Info: Target content size is bigger than " + MAX_CONTENT_LENGTH + " bytes. Content will be splitted in mutitple files. Don't worry, I'll automatically take care of everything!");
                cur_content = targetContents.getNewContent(contentDetails);
                cur_content_size = 0L;
            }
            cur_content_size += child.getFilesize();
            if (!child.isNotInPackage()) {
                System.out.println("Set content to " + String.format("%08X (%08X,%08X)", cur_content.getID(), cur_content_size, child.getFilesize()) + " for: " + filePath);
            }
            child.setContent(cur_content);
            result = true;
        }
        if (result) {
            cur_entry.setContent(cur_content_first);
        }
        return result;
    }
}

