/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.nuspackage.packaging;

import com.tim.nuspacker.nuspackage.Cert;
import com.tim.nuspacker.nuspackage.FST;
import com.tim.nuspacker.nuspackage.TMD;
import com.tim.nuspacker.nuspackage.Ticket;
import com.tim.nuspacker.nuspackage.contents.Content;
import com.tim.nuspacker.nuspackage.contents.ContentInfo;
import com.tim.nuspacker.nuspackage.contents.ContentInfos;
import com.tim.nuspacker.nuspackage.contents.Contents;
import com.tim.nuspacker.nuspackage.crypto.Encryption;
import com.tim.nuspacker.utils.HashUtil;
import java.io.FileOutputStream;
import java.io.IOException;

public class NUSPackage {
    private Ticket ticket;
    private TMD tmd;
    private FST fst;
    private String outputdir = "output";

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public String getOutputdir() {
        return this.outputdir;
    }

    public void setOutputdir(String outputdir) {
        this.outputdir = outputdir;
    }

    public TMD getTMD() {
        return this.tmd;
    }

    public void setTMD(TMD tmd) {
        this.tmd = tmd;
    }

    public FST getFST() {
        return this.fst;
    }

    public void setFST(FST fst) {
        this.fst = fst;
    }

    public Contents getContents() {
        return this.getFST().getContents();
    }

    public ContentInfos getContentInfos() {
        return this.getTMD().getContentInfos();
    }

    public void packContents(String outputDir) {
        if (outputDir != null && !outputDir.isEmpty()) {
            this.setOutputdir(outputDir);
        }
        System.out.println("Packing contents.");
        try {
            this.getFST().getContents().packContents(outputDir);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Content fstContent = this.getContents().getFSTContent();
        fstContent.setHash(HashUtil.hashSHA1(this.getFST().getAsData()));
        fstContent.setEncryptedFileSize(this.getFST().getAsData().length);
        ContentInfo contentInfo = this.getContentInfos().getContentInfo(0);
        contentInfo.setSHA2Hash(HashUtil.hashSHA2(this.getContents().getAsData()));
        this.getTMD().updateContentInfoHash();
        try {
            FileOutputStream fos = new FileOutputStream(String.valueOf(this.getOutputdir()) + "/title.tmd");
            fos.write(this.tmd.getAsData());
            fos.close();
            System.out.println("TMD saved to    " + this.getOutputdir() + "/title.tmd");
            fos = new FileOutputStream(String.valueOf(this.getOutputdir()) + "/title.cert");
            fos.write(Cert.getCertAsData());
            fos.close();
            System.out.println("Cert saved to   " + this.getOutputdir() + "/title.cert");
            fos = new FileOutputStream(String.valueOf(this.getOutputdir()) + "/title.tik");
            fos.write(this.ticket.getAsData());
            fos.close();
            System.out.println("Ticket saved to " + this.getOutputdir() + "/title.tik");
            System.out.println();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printTicketInfos() {
        System.out.println("Encrypted with this key           : " + this.getTicket().getDecryptedKey());
        System.out.println("Key encrypted with this key       : " + this.getTicket().getEncryptWith());
        System.out.println();
        System.out.println("Encrypted key                     : " + this.getTicket().getEncryptedKey());
    }

    public Encryption getEncryption() {
        return this.getTMD().getEncryption();
    }
}

