/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.nuspackage.packaging;

import com.tim.nuspacker.nuspackage.FST;
import com.tim.nuspacker.nuspackage.TMD;
import com.tim.nuspacker.nuspackage.Ticket;
import com.tim.nuspacker.nuspackage.contents.Content;
import com.tim.nuspacker.nuspackage.contents.Contents;
import com.tim.nuspacker.nuspackage.fst.FSTEntries;
import com.tim.nuspacker.nuspackage.fst.FSTEntry;
import com.tim.nuspacker.nuspackage.packaging.ContentRulesService;
import com.tim.nuspacker.nuspackage.packaging.NUSPackage;
import com.tim.nuspacker.nuspackage.packaging.NusPackageConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class NUSPackageFactory {
    private static Map<Content, NUSPackage> contentDictionary = new HashMap<Content, NUSPackage>();
    private static Map<FST, NUSPackage> FSTDictionary = new HashMap<FST, NUSPackage>();
    private static Map<TMD, NUSPackage> TMDDictionary = new HashMap<TMD, NUSPackage>();
    private static Map<FSTEntries, NUSPackage> FSTEntriesDictionary = new HashMap<FSTEntries, NUSPackage>();
    private static Map<Contents, NUSPackage> contentsDictionary = new HashMap<Contents, NUSPackage>();

    public static NUSPackage createNewPackage(NusPackageConfiguration config) {
        NUSPackage nusPackage = new NUSPackage();
        Contents contents = new Contents();
        FST fst = new FST(contents);
        NUSPackageFactory.addFSTDictonary(fst, nusPackage);
        FSTEntries entries = fst.getFSTEntries();
        NUSPackageFactory.addFSTEntriesDictonary(fst.getFSTEntries(), nusPackage);
        FSTEntry root = entries.getRootEntry();
        root.setContent(contents.getFSTContent());
        File dir_read = new File(config.getDir());
        NUSPackageFactory.readFiles(dir_read.listFiles(), root);
        System.out.println("Files read. Set it to content files.");
        ContentRulesService.applyRules(root, contents, config.getRules());
        NUSPackageFactory.addContentsDictonary(contents, nusPackage);
        NUSPackageFactory.addContentDictonary(contents, nusPackage);
        System.out.println("Generating the FST.");
        fst.update();
        System.out.println("Generating the Ticket.");
        Ticket ticket = new Ticket(config.getAppInfo().getTitleID(), config.getEncryptionKey(), config.getEncryptKeyWith());
        System.out.println("Creating the TMD.");
        TMD tmd = new TMD(config.getAppInfo(), fst, ticket);
        tmd.update();
        NUSPackageFactory.addTMDDictonary(tmd, nusPackage);
        nusPackage.setFST(fst);
        nusPackage.setTicket(ticket);
        nusPackage.setTMD(tmd);
        return nusPackage;
    }

    private static void addContentsDictonary(Contents contents, NUSPackage nusPackage) {
        contentsDictionary.put(contents, nusPackage);
    }

    private static void addContentDictonary(Contents contents, NUSPackage nusPackage) {
        for (Content c : contents.getContents()) {
            if (contentDictionary.containsKey(c)) continue;
            contentDictionary.put(c, nusPackage);
        }
    }

    private static void addTMDDictonary(TMD tmd, NUSPackage nusPackage) {
        TMDDictionary.put(tmd, nusPackage);
    }

    private static void addFSTDictonary(FST fst, NUSPackage nusPackage) {
        FSTDictionary.put(fst, nusPackage);
    }

    private static void addFSTEntriesDictonary(FSTEntries fstEntries, NUSPackage nusPackage) {
        FSTEntriesDictionary.put(fstEntries, nusPackage);
    }

    public static NUSPackage getPackageByContent(Content content) {
        if (contentDictionary.containsKey(content)) {
            return contentDictionary.get(content);
        }
        return null;
    }

    public static NUSPackage getPackageByFST(FST fst) {
        if (FSTDictionary.containsKey(fst)) {
            return FSTDictionary.get(fst);
        }
        return null;
    }

    public static NUSPackage getPackageByTMD(TMD tmd) {
        if (TMDDictionary.containsKey(tmd)) {
            return TMDDictionary.get(tmd);
        }
        return null;
    }

    public static NUSPackage getPackageByContents(Contents contents) {
        if (contentsDictionary.containsKey(contents)) {
            return contentsDictionary.get(contents);
        }
        return null;
    }

    public static NUSPackage getPackageByFSTEntires(FSTEntries fstEntries) {
        if (FSTEntriesDictionary.containsKey(fstEntries)) {
            return FSTEntriesDictionary.get(fstEntries);
        }
        return null;
    }

    public static void readFiles(File[] list, FSTEntry parent) {
        NUSPackageFactory.readFiles(list, parent, false);
    }

    public static void readFiles(File[] list, FSTEntry parent, boolean notInNUSPackage) {
        File f;
        File[] fileArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            f = fileArray[n2];
            if (!f.isDirectory()) {
                parent.addChildren(new FSTEntry(f, notInNUSPackage));
            }
            ++n2;
        }
        fileArray = list;
        n = list.length;
        n2 = 0;
        while (n2 < n) {
            f = fileArray[n2];
            if (f.isDirectory()) {
                FSTEntry newdir = new FSTEntry(f, notInNUSPackage);
                parent.addChildren(newdir);
                NUSPackageFactory.readFiles(f.listFiles(), newdir, notInNUSPackage);
            }
            ++n2;
        }
    }
}

