/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.utils;

import com.tim.nuspacker.utils.ByteArrayBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Utils {
    public static void deleteDir(File file) {
        File[] contents = file.listFiles();
        if (contents != null) {
            File[] fileArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                Utils.deleteDir(f);
                ++n2;
            }
        }
        file.deleteOnExit();
    }

    public static long align(long input, int alignment) {
        long newSize = input / (long)alignment;
        if (newSize * (long)alignment != input) {
            ++newSize;
        }
        return newSize *= (long)alignment;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    public static long HexStringToLong(String s) {
        try {
            BigInteger bi = new BigInteger(s, 16);
            return bi.longValue();
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static String ByteArrayToString(byte[] ba) {
        if (ba == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(ba.length * 2);
        byte[] byArray = ba;
        int n = ba.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hex.append(String.format("%02X", b));
            ++n2;
        }
        return hex.toString();
    }

    public static int getChunkFromStream(InputStream inputStream, byte[] output, ByteArrayBuffer overflowbuffer, long excptedSize) throws IOException {
        int bytesRead = -1;
        int inBlockBuffer = 0;
        while ((bytesRead = inputStream.read(overflowbuffer.buffer, overflowbuffer.getLengthOfDataInBuffer(), overflowbuffer.getSpaceLeft())) > 0) {
            overflowbuffer.addLengthOfDataInBuffer(bytesRead);
            if ((long)(inBlockBuffer + overflowbuffer.getLengthOfDataInBuffer()) > excptedSize) {
                long tooMuch = (long)(inBlockBuffer + bytesRead) - excptedSize;
                long toRead = excptedSize - (long)inBlockBuffer;
                System.arraycopy(overflowbuffer.buffer, 0, output, inBlockBuffer, (int)toRead);
                inBlockBuffer = (int)((long)inBlockBuffer + toRead);
                System.arraycopy(overflowbuffer.buffer, (int)toRead, overflowbuffer.buffer, 0, (int)tooMuch);
                overflowbuffer.setLengthOfDataInBuffer((int)tooMuch);
            } else {
                System.arraycopy(overflowbuffer.buffer, 0, output, inBlockBuffer, overflowbuffer.getLengthOfDataInBuffer());
                inBlockBuffer += overflowbuffer.getLengthOfDataInBuffer();
                overflowbuffer.resetLengthOfDataInBuffer();
            }
            if ((long)inBlockBuffer != excptedSize) continue;
        }
        return inBlockBuffer;
    }

    public static long getUnsingedIntFromBytes(byte[] input, int offset) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.position(4);
        buffer.put(Arrays.copyOfRange(input, offset, offset + 4));
        return buffer.getLong(0);
    }

    public static int getIntFromBytes(byte[] input, int offset) {
        return ByteBuffer.wrap(Arrays.copyOfRange(input, offset, offset + 4)).getInt();
    }

    public static long copyFileInto(File file, OutputStream out) throws IOException {
        return Utils.copyFileInto(file, out, null);
    }

    public static long copyFileInto(File file, OutputStream out, String output) throws IOException {
        int read;
        if (output != null) {
            System.out.print(output);
        }
        FileInputStream in = new FileInputStream(file);
        long written = 0L;
        long filesize = file.length();
        int buffer_size = 65536;
        byte[] buffer = new byte[buffer_size];
        long cycle = 0L;
        while ((read = in.read(buffer)) > 0) {
            out.write(buffer, 0, read);
            written += (long)read;
            if (cycle % 10L == 0L && output != null) {
                int progress = (int)((double)written * 1.0 / (double)filesize * 1.0 * 100.0);
                System.out.print("\r" + output + ": " + progress + "%");
            }
            if (written < filesize) continue;
        }
        if (output != null) {
            System.out.println("\r" + output + ": 100%");
        }
        in.close();
        return written;
    }
}

