/*
 * Decompiled with CFR 0.152.
 */
package com.tim.nuspacker.utils;

import com.tim.nuspacker.utils.AppXMLInfo;
import com.tim.nuspacker.utils.Utils;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLParser {
    private Document document;

    public void loadDocument(File doc) throws ParserConfigurationException, SAXException, IOException {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = document = builder.parse(doc);
    }

    public AppXMLInfo getAppXMLInfo() {
        AppXMLInfo appxmlinfo = new AppXMLInfo();
        appxmlinfo.setOSVersion(this.getValueOfElementAsLongHex("os_version", 0));
        appxmlinfo.setTitleID(this.getValueOfElementAsLongHex("title_id", 0));
        appxmlinfo.setTitleVersion((short)this.getValueOfElementAsLongHex("title_version", 0));
        appxmlinfo.setSDKVersion((int)this.getValueOfElementAsInt("sdk_version", 0));
        appxmlinfo.setAppType((int)this.getValueOfElementAsLongHex("app_type", 0));
        appxmlinfo.setGroupID((short)this.getValueOfElementAsLongHex("group_id", 0));
        appxmlinfo.setOSMask(this.getValueOfElementAsByteArray("os_mask", 0));
        appxmlinfo.setCommon_id(this.getValueOfElementAsLongHex("common_id", 0));
        return appxmlinfo;
    }

    public long getValueOfElementAsInt(String element, int index) {
        return Integer.parseInt(this.getValueOfElement(element, index));
    }

    public long getValueOfElementAsLong(String element, int index) {
        return Long.parseLong(this.getValueOfElement(element, index));
    }

    public long getValueOfElementAsLongHex(String element, int index) {
        return Utils.HexStringToLong(this.getValueOfElement(element, index));
    }

    public byte[] getValueOfElementAsByteArray(String element, int index) {
        return Utils.hexStringToByteArray(this.getValueOfElement(element, index));
    }

    public String getValueOfElement(String element) {
        return this.getValueOfElement(element, 0);
    }

    public String getValueOfElement(String element, int index) {
        NodeList list;
        if (this.document == null) {
            System.out.println("Please load the document first.");
        }
        if ((list = this.document.getElementsByTagName(element)) == null) {
            return "";
        }
        Node node = list.item(index);
        if (node == null) {
            return "";
        }
        return node.getTextContent().toString();
    }
}

