﻿

Global *SHA1_Hash=AllocateMemory(20)

Procedure SHA1_Compress(*SHA1Hash, *Chunk)
 
  Macro ROUNDTAIL(a, b, e, i, k)
		! ROL b, 30
		! LEA e, [e+esi+k]
		! MOV esi, a
		! ROL esi, 5
		! ADD e, esi
	EndMacro
	
  Macro ROUND0a(a, b, c, d, e, i)
		! MOV esi, [edi+(i*4)]
		! BSWAP esi
		! MOV [esp+(i*4)], esi
		! ADD e, esi
		! MOV esi, c
		! XOR esi, d
		! AND esi, b
		! XOR esi, d
		ROUNDTAIL(a, b, e, i, $5A827999)
	EndMacro
	
	Macro SCHEDULE(i, e)
		! MOV esi, [esp+(((i- 3) and 15)*4)]
		! XOR esi, [esp+(((i- 8) and 15)*4)]
		! XOR esi, [esp+(((i-14) and 15)*4)]
		! XOR esi, [esp+(((i-16) and 15)*4)]
		! ROL esi, 1
		! ADD e, esi
		! MOV [esp+((i and 15)*4)], esi
	EndMacro
	
	Macro ROUND0b(a, b, c, d, e, i)
		SCHEDULE(i, e)
		! MOV esi, c
		! XOR esi, d
		! AND esi, b
		! XOR esi, d
		ROUNDTAIL(a, b, e, i, $5A827999)
	EndMacro
	
	Macro ROUND1(a, b, c, d, e, i)
		SCHEDULE(i, e)
		! MOV esi, b
		! XOR esi, c
		! XOR esi, d
		ROUNDTAIL(a, b, e, i, $6ED9EBA1)
	EndMacro
	
	Macro ROUND2(a, b, c, d, e, i)
		SCHEDULE(i, e)
		! MOV esi, c
		! MOV edi, c
		! OR  esi, d
		! AND esi, b
		! AND edi, d
		! OR  esi, edi
		ROUNDTAIL(a, b, e, i, $8F1BBCDC)
	EndMacro
		
  Macro ROUND3(a, b, c, d, e, i)
		SCHEDULE(i, e)
		! MOV esi, b
		! XOR esi, c
		! XOR esi, d
		ROUNDTAIL(a, b, e, i, $CA62C1D6)
	EndMacro
	
	; Save registers
	! SUB esp, 80
	! MOV [esp+64], ebx
	! MOV [esp+68], esi
	! MOV [esp+72], edi
	! MOV [esp+76], ebp
	
	; Load arguments
	! MOV esi, [esp+84] ; state
	! MOV edi, [esp+88] ; block
	! MOV eax, [esi]    ; a
	! MOV ebx, [esi+4]  ; b
	! MOV ecx, [esi+8]  ; c
	! MOV edx, [esi+12] ; d
	! MOV ebp, [esi+16] ; e
	
	; 80 rounds of hashing
	ROUND0a(eax, ebx, ecx, edx, ebp,  0)
	ROUND0a(ebp, eax, ebx, ecx, edx,  1)
	ROUND0a(edx, ebp, eax, ebx, ecx,  2)
	ROUND0a(ecx, edx, ebp, eax, ebx,  3)
	ROUND0a(ebx, ecx, edx, ebp, eax,  4)
	ROUND0a(eax, ebx, ecx, edx, ebp,  5)
	ROUND0a(ebp, eax, ebx, ecx, edx,  6)
	ROUND0a(edx, ebp, eax, ebx, ecx,  7)
	ROUND0a(ecx, edx, ebp, eax, ebx,  8)
	ROUND0a(ebx, ecx, edx, ebp, eax,  9)
	ROUND0a(eax, ebx, ecx, edx, ebp, 10)
	ROUND0a(ebp, eax, ebx, ecx, edx, 11)
	ROUND0a(edx, ebp, eax, ebx, ecx, 12)
	ROUND0a(ecx, edx, ebp, eax, ebx, 13)
	ROUND0a(ebx, ecx, edx, ebp, eax, 14)
	ROUND0a(eax, ebx, ecx, edx, ebp, 15)
	ROUND0b(ebp, eax, ebx, ecx, edx, 16)
	ROUND0b(edx, ebp, eax, ebx, ecx, 17)
	ROUND0b(ecx, edx, ebp, eax, ebx, 18)
	ROUND0b(ebx, ecx, edx, ebp, eax, 19)
	ROUND1(eax, ebx, ecx, edx, ebp, 20)
	ROUND1(ebp, eax, ebx, ecx, edx, 21)
	ROUND1(edx, ebp, eax, ebx, ecx, 22)
	ROUND1(ecx, edx, ebp, eax, ebx, 23)
	ROUND1(ebx, ecx, edx, ebp, eax, 24)
	ROUND1(eax, ebx, ecx, edx, ebp, 25)
	ROUND1(ebp, eax, ebx, ecx, edx, 26)
	ROUND1(edx, ebp, eax, ebx, ecx, 27)
	ROUND1(ecx, edx, ebp, eax, ebx, 28)
	ROUND1(ebx, ecx, edx, ebp, eax, 29)
	ROUND1(eax, ebx, ecx, edx, ebp, 30)
	ROUND1(ebp, eax, ebx, ecx, edx, 31)
	ROUND1(edx, ebp, eax, ebx, ecx, 32)
	ROUND1(ecx, edx, ebp, eax, ebx, 33)
	ROUND1(ebx, ecx, edx, ebp, eax, 34)
	ROUND1(eax, ebx, ecx, edx, ebp, 35)
	ROUND1(ebp, eax, ebx, ecx, edx, 36)
	ROUND1(edx, ebp, eax, ebx, ecx, 37)
	ROUND1(ecx, edx, ebp, eax, ebx, 38)
	ROUND1(ebx, ecx, edx, ebp, eax, 39)
	ROUND2(eax, ebx, ecx, edx, ebp, 40)
	ROUND2(ebp, eax, ebx, ecx, edx, 41)
	ROUND2(edx, ebp, eax, ebx, ecx, 42)
	ROUND2(ecx, edx, ebp, eax, ebx, 43)
	ROUND2(ebx, ecx, edx, ebp, eax, 44)
	ROUND2(eax, ebx, ecx, edx, ebp, 45)
	ROUND2(ebp, eax, ebx, ecx, edx, 46)
	ROUND2(edx, ebp, eax, ebx, ecx, 47)
	ROUND2(ecx, edx, ebp, eax, ebx, 48)
	ROUND2(ebx, ecx, edx, ebp, eax, 49)
	ROUND2(eax, ebx, ecx, edx, ebp, 50)
	ROUND2(ebp, eax, ebx, ecx, edx, 51)
	ROUND2(edx, ebp, eax, ebx, ecx, 52)
	ROUND2(ecx, edx, ebp, eax, ebx, 53)
	ROUND2(ebx, ecx, edx, ebp, eax, 54)
	ROUND2(eax, ebx, ecx, edx, ebp, 55)
	ROUND2(ebp, eax, ebx, ecx, edx, 56)
	ROUND2(edx, ebp, eax, ebx, ecx, 57)
	ROUND2(ecx, edx, ebp, eax, ebx, 58)
	ROUND2(ebx, ecx, edx, ebp, eax, 59)
	ROUND3(eax, ebx, ecx, edx, ebp, 60)
	ROUND3(ebp, eax, ebx, ecx, edx, 61)
	ROUND3(edx, ebp, eax, ebx, ecx, 62)
	ROUND3(ecx, edx, ebp, eax, ebx, 63)
	ROUND3(ebx, ecx, edx, ebp, eax, 64)
	ROUND3(eax, ebx, ecx, edx, ebp, 65)
	ROUND3(ebp, eax, ebx, ecx, edx, 66)
	ROUND3(edx, ebp, eax, ebx, ecx, 67)
	ROUND3(ecx, edx, ebp, eax, ebx, 68)
	ROUND3(ebx, ecx, edx, ebp, eax, 69)
	ROUND3(eax, ebx, ecx, edx, ebp, 70)
	ROUND3(ebp, eax, ebx, ecx, edx, 71)
	ROUND3(edx, ebp, eax, ebx, ecx, 72)
	ROUND3(ecx, edx, ebp, eax, ebx, 73)
	ROUND3(ebx, ecx, edx, ebp, eax, 74)
	ROUND3(eax, ebx, ecx, edx, ebp, 75)
	ROUND3(ebp, eax, ebx, ecx, edx, 76)
	ROUND3(edx, ebp, eax, ebx, ecx, 77)
	ROUND3(ecx, edx, ebp, eax, ebx, 78)
	ROUND3(ebx, ecx, edx, ebp, eax, 79)
	
	; Save updated state
	! MOV esi, [esp+84]
	! ADD [esi], eax
	! ADD [esi+4], ebx
	! ADD [esi+8], ecx
  ! ADD [esi+12], edx
  ! ADD [esi+16], ebp
  
	; Restore registers
	! MOV ebx, [esp+64]
	! MOV esi, [esp+68]
	! MOV edi, [esp+72]
	! MOV ebp, [esp+76]
	! ADD esp, 80
EndProcedure

Procedure SHA1_Hash(*Data, DataSize, *SHA1Hash)
 ; Init Hash values
 PokeL(*SHA1Hash, $67452301) : PokeL(*SHA1Hash+4, $EFCDAB89) : PokeL(*SHA1Hash+8, $98BADCFE) : PokeL(*SHA1Hash+12, $10325476) : PokeL(*SHA1Hash+16, $C3D2E1F0)
 
 ; Hash 64 Bytes chunks
 i=0 : While DataSize - i >= 64 : SHA1_Compress(*SHA1Hash, *Data+i) : i+64 : Wend
 
 RemainingBytes = DataSize-i
 *Block=AllocateMemory(64)
 CopyMemory(*Data+i, *Block, RemainingBytes)
 
 PokeB(*Block+RemainingBytes, $80)
 RemainingBytes+1
 If 64-RemainingBytes >= 8
   FillMemory(*Block+RemainingBytes, 56-RemainingBytes)
 Else
   FillMemory(*Block+RemainingBytes, 64-RemainingBytes)
   SHA1_Compress(*SHA1Hash, *Block)
   FillMemory(*Block, 56)
 EndIf
  
 Data_Size.q = DataSize : Data_Size = Data_Size<<3
 For i=0 To 7 : PokeB(*Block+63-i, Data_Size>>(i<<3)) : Next
 SHA1_Compress(*SHA1Hash, *Block)
 
 FreeMemory(*Block)

EndProcedure
 
; IDE Options = PureBasic 5.11 (Windows - x86)
; CursorPosition = 214
; Folding = A5
; EnableXP