local BloodParticles = Behavior("BloodParticles")

function BloodParticles:initialize(sprayDirection)
  self.sprayDirection = sprayDirection:normalized()

  self.particles = self:addComponent("ParticleEmitter")
  self.particles.image ="default/blood_drop.png"
  self.particles.worldSpace = false

  if math.abs(sprayDirection.x) > math.abs(sprayDirection.y) then
    sprayDirection.y = 0.0
  else
    sprayDirection.x = 0.0
  end

  if sprayDirection.y > 0.0 then
    sprayDirection.y = sprayDirection.y * 3.0
  end

  sprayDirection:normalize()

  local velocity = sprayDirection * Vector(64.0, 48.0) + sprayDirection:perpendicular() * Vector(0.0, 48.0)

  self.particles:setParticleDef({
    lifetimeMin = 0.45,
    lifetimeMax = 0.55,
    sizeMin = 3.0,
    sizeMax = 8.0,
    growth = 0.0,
    velocityMin = Vector(velocity.x, velocity.y),
    velocityMax = Vector(velocity.x * 2.25, velocity.y * 1.45),
    acceleration = Vector(0.0, -400.0),
    colorStart = Color(1.0, 1.0, 1.0, 0.0),
    colorEnd = Color(1.0, 1.0, 1.0, 1.0),
    blendMode = "alphaBlend"
  })

  if not Kernel.bloodsplatterRenderer then
    Kernel:addComponent("BloodsplatterRenderer")
  end

  self.nextSpawn = 0.0
  self.spawnsLeft = 8

  self.splattersLeft = 4
  self.nextSplatterTime = 0.45
end

function BloodParticles:update(deltaTime)
  self.nextSpawn = self.nextSpawn - deltaTime
  if self.nextSpawn < 0.0 and self.spawnsLeft > 0 then
    self.spawnsLeft = self.spawnsLeft - 1
    self.nextSpawn = 0.01 + Random.value() * 0.005
    self.particles:spawnParticles(Vector.zero(), 4)
  elseif self.spawnsLeft == 0 and self.particles:getAliveParticleCount() == 0 then
    self.object:destroy()
  end

  self.nextSplatterTime = self.nextSplatterTime - deltaTime
  if self.nextSplatterTime < 0.0 and self.splattersLeft > 0 then
    local pos = self.particles:getLastDeadParticlePosition()
    if pos:len() >= 1.0 then
      self.splattersLeft = self.splattersLeft - 1
      self.nextSplatterTime = 0.05
      Kernel.bloodsplatterRenderer:addSplatter(self.transform.worldPosition + pos)
    end
  end
end
