local BloodsplatterRenderer = Behavior("BloodsplatterRenderer")

function BloodsplatterRenderer:initialize()
  local renderer = self:addComponent("SpriteRenderer")
  renderer:addImage("default/blood_new_big.png")
  renderer:addImage("default/blood_new_small.png")
  renderer.worldSpace = true
  renderer.fadeOutSpeed = 0.05

  self.size = Vector(50.0, 50.0)
  self.smallSize = Vector(16.0, 16.0)
end

function BloodsplatterRenderer:addSplatter(position)
  if position.x < 0.0 or position.y < 0.0 then
    return
  end

  local uvStart = Vector(0.166666, 0.0) * math.floor(Random.value() * 6.0)

  self.spriteRenderer:addInstance({
    position = position - self.size * 0.5,
    size = self.size,
    imageIndex = 0,
    uvStart = uvStart,
    uvEnd = uvStart + Vector(0.16666, 1.0)
  })

  for i=1,3 do
    local pos = position + Vector(-1.0 + Random.value() * 2.0, -1.0 + Random.value() * 2.0) * 16.0
    uvStart = Vector(0.166666, 0.0) * math.floor(Random.value() * 6.0)

    self.spriteRenderer:addInstance({
      position = pos - self.smallSize * 0.5,
      size = self.smallSize,
      imageIndex = 1,
      uvStart = uvStart,
      uvEnd = uvStart + Vector(0.16666, 1.0)
    })
  end
end
