local FootstepsRenderer = Behavior("FootstepsRenderer")

function FootstepsRenderer:initialize()
  local renderer = self:addComponent("SpriteRenderer")
  renderer:addImage("default/footstep.png")
  renderer:setWorldSpace(true)
  renderer:setFadeOutSpeed(0.1)

  self.lastPosition = self.transform.worldPosition
  self.footstepDistance = 16.0
  self.footstepDisplacement = 4.0
  self.nextFootstepDistance = self.footstepDistance
  self.nextFootstepDisplacement = self.footstepDisplacement

  self.size = Vector(12.0, 8.0)
end

function FootstepsRenderer:update(deltaTime)
  local worldPosition = self.transform.worldPosition
  local positionDelta = worldPosition - self.lastPosition
  self.lastPosition = worldPosition

  local dist = positionDelta:len()
  if dist ~= 0.0 then
    positionDelta = positionDelta / dist
  end

  self.nextFootstepDistance = self.nextFootstepDistance - dist
  if self.nextFootstepDistance <= 0.0 then
    self.nextFootstepDistance = self.footstepDistance

    local footstepPosition = worldPosition + positionDelta:perpendicular() * self.nextFootstepDisplacement
    if self.nextFootstepDisplacement > 0.0 then
      self.nextFootstepDisplacement = -self.footstepDisplacement
    else
      self.nextFootstepDisplacement = self.footstepDisplacement
    end

    self.spriteRenderer:addInstance({
      position = footstepPosition,
      size = self.size
    })
  end
end
