local HealingFX = Behavior("HealingFX")

function HealingFX:initialize()
  self.particles = self:addComponent("ParticleEmitter")
  self.particles:setImage("default/healing.png")

  self.particles:setParticleDef({
    lifetimeMin = 0.5,
    lifetimeMax = 2.5,
    sizeMin = 12.0,
    sizeMax = 32.0,
    growth = 4.0,
    velocityMin = Vector(-32.0, 32.0),
    velocityMax = Vector(32.0, 32.0),
    acceleration = Vector(0.0, 0.0),
    colorStart = Color(1.0, 1.0, 1.0, 0.45),
    colorEnd = Color(1.0, 1.0, 1.0, 0.0),
    blendMode = "alphaBlend"
  })

  self.nextSpawn = 0.0
end

function HealingFX:update(deltaTime)
  self.nextSpawn = self.nextSpawn - deltaTime
  if self.nextSpawn < 0.0 then
    self.particles:spawnParticles(Vector(0.0, 12.0), 4)
    self.nextSpawn = 0.5
  end
end
