local LifedrainFX = Behavior("LifedrainFX")

function LifedrainFX:initialize(targetTransform)
  self.targetTransform = targetTransform
  self.size = Vector(8.0, 8.0)
  self.damping = 0.99

  self.particleCount = 64

  local renderer = self:addComponent("SpriteRenderer")
  renderer:addImage("default/blood_drop.png")
  renderer.worldSpace = true

  local position = self.transform.worldPosition

  self.positions = {}
  self.velocities = {}

  for i=0,self.particleCount do
    renderer:addInstance({
      position = position,
      size = self.size,
      imageIndex = 0,
      zOrder = 105,
      color = Color(1.0, 1.0, 1.0, 0.55 + Random.value() * 0.25)
    })

    self.velocities[i+1] = Random.unitVector() * (512.0 + Random.value() * 512.0)
    self.positions[i+1] = position
  end

  self.mainCo = Co.create(function()
    local timeout = 0.5

    while timeout >= 0.0 do
      timeout = timeout - Time.fixedDeltaTime


      for i=0,self.particleCount do
        local dir = (self.targetTransform.worldPosition - self.positions[i+1]):normalized() * 256.0
        self.velocities[i+1] = Vector.lerp(self.velocities[i+1], dir, Time.fixedDeltaTime * 16.0)
        self.positions[i+1] = self.positions[i+1] + self.velocities[i+1] * Time.fixedDeltaTime
        renderer:setInstancePosition(i, self.positions[i+1])
      end

      Co.yield()
    end
  end)
end

function LifedrainFX:update()
  if not self.mainCo:update() then
    self.object:destroy()
  end
end
