local PoisonFX = Behavior("PoisonFX")

function PoisonFX:initialize()
  self.particles = self:addComponent("ParticleEmitter")
  self.particles:setImage("default/particle.png")

  self.particles:setParticleDef({
    lifetimeMin = 0.5,
    lifetimeMax = 2.5,
    sizeMin = 24.0,
    sizeMax = 48.0,
    growth = 16.0,
    velocityMin = Vector(-16.0, 12.0),
    velocityMax = Vector(16.0, 64.0),
    acceleration = Vector(0.0, 0.0),
    colorStart = Color(0.0, 0.5, 0.0, 0.55),
    colorEnd = Color(0.0, 0.5, 0.0, 0.0),
    blendMode = "alphaBlend",
    worldSpace = true
  })

  self.nextSpawn = 0.0
end

function PoisonFX:update(deltaTime)
  self.nextSpawn = self.nextSpawn - deltaTime
  if self.nextSpawn < 0.0 then
    self.particles:spawnParticles(Vector(0.0, 12.0), 4)
    self.nextSpawn = 0.5
  end
end
