local Puff = Behavior("Puff")

Puff.editorIcon("puff_fx/puff_fx.json")

function Puff:initialize(scale)
  scale = scale or 0.4

  local renderer = self:addComponent("SkeletonRenderer")
  renderer.skeleton = "puff_fx/puff_fx.json"
  renderer.zOrder = 110
  renderer:enableEvents()
  renderer:setAnimation(0, "puff")
  renderer.timeScale = 1.5

  self.transform.localScale = Vector(scale, scale)

  self:on("animationComplete", function()
    self.object:destroy()
  end)
end
