local RotatingLight = Behavior("RotatingLight")

RotatingLight.property("size", 256.0)
RotatingLight.property("shadowStrength", 0.5)
RotatingLight.property("color", Color(1.0, 1.0, 1.0, 1.0))
RotatingLight.property("steps", 32.0)
RotatingLight.property("radius", 64.0)
RotatingLight.property("rotationSpeed", 1.0)
RotatingLight.property("ambientIntensity", 0.25)

RotatingLight.editorIcon("editor/light.png")

function RotatingLight:initialize(properties)
  self.properties = properties

  local lightSource = self:addComponent("LightSource")
  lightSource.size = properties.size
  lightSource.shadowStrength = properties.shadowStrength
  lightSource.color = properties.color
  lightSource.ambientIntensity = properties.ambientIntensity

  self.center = self.transform.worldPosition
  self.t = 0.0
end

function RotatingLight:update(deltaTime)
  self.t = self.t + deltaTime * self.properties.rotationSpeed
  local position = self.center + Vector(math.cos(self.t), math.sin(self.t)) * self.properties.radius
  self.transform.localPosition = position
end
