local SimpleLight = Behavior("SimpleLight")

SimpleLight.property("size", 256.0)
SimpleLight.property("shadowStrength", 0.5)
SimpleLight.property("color", Color(1.0, 1.0, 1.0, 1.0))
SimpleLight.property("ambientIntensity", 0.25)

SimpleLight.editorIcon("editor/light.png")

function SimpleLight:initialize(properties)
  local lightSource = self:addComponent("LightSource")
  lightSource.size = properties.size
  lightSource.shadowStrength = properties.shadowStrength
  lightSource.color = properties.color
  lightSource.ambientIntensity = properties.ambientIntensity
end
