local SnowParticleSystem = Behavior("SnowParticleSystem")

SnowParticleSystem.property("lifetimeMin", 16.0)
SnowParticleSystem.property("lifetimeMax", 32.0)
SnowParticleSystem.property("sizeMin", 0.6)
SnowParticleSystem.property("sizeMax", 6.0)
SnowParticleSystem.property("growthFactor", 0.06)
SnowParticleSystem.property("velocityMin", Vector(-96.0, 192.0))
SnowParticleSystem.property("velocityMax", Vector(96.0, -384.0))
SnowParticleSystem.property("acceleration", Vector(0.0, -16.0))
SnowParticleSystem.property("colorStart", Color(1.0, 1.0, 1.0, 0.85))
SnowParticleSystem.property("colorEnd", Color(0.5, 1.0, 1.0, 0.0))
SnowParticleSystem.property("blendMode", "alphaBlend")
SnowParticleSystem.property("spawnRate", 0.1)

SnowParticleSystem.editorIcon(SnowParticleSystem, "editor/vfx.png")

function SnowParticleSystem:initialize(properties)
  self.properties = properties

  self.particles = self:addComponent("ParticleEmitter")
  self.particles:setMaxParticleCount(16000)
  self.particles.image = "default/circle.png"
  self.particles.worldSpace = true
  self.particles:setParticleDef(self.properties)
  self.nextSpawn = self.properties.spawnRate

  self:prewarm(16)  
end

function SnowParticleSystem:update(deltaTime)
  self.nextSpawn = self.nextSpawn - deltaTime
  if self.nextSpawn < 0 then
    self.nextSpawn = self.properties.spawnRate

    local cameraSize = Camera.getSize()
    local cameraPosition = Camera.getPosition()

    for i=0,16 do
      local pos = cameraPosition - Vector(512.0, 0.0) + Vector(Random.value() * (cameraSize.x + 1024.0), cameraSize.y + 48.0)
      self.particles:spawnParticles(pos, 1)
    end
  end
end

function SnowParticleSystem:setProperty(property, value)
  self.properties[property] = value
  self.particles:setParticleDef(self.properties)
end

function SnowParticleSystem:prewarm(iterations)
  iterations = iterations or 16

  for q=0,iterations do
    local cameraSize = Camera.getSize()
    local cameraPosition = Camera.getPosition()

    for i=0,16 do
      local pos = cameraPosition + Vector(Random.value() * cameraSize.x, cameraSize.y + 48.0)
      self.particles:spawnParticles(pos, 1)
    end

    self.particles:preWarm(16)
  end
end