local Spark = Behavior("Spark")

Spark.property("animationName", "blink")
Spark.property("scale", 1.0)
Spark.property("minTime", 4.0)
Spark.property("maxTime", 8.0)

Spark.editorIcon("spark/spark.json")

function Spark:initialize(properties)
  self.properties = properties

  self:addComponent("SkeletonRenderer")
  self.skeletonRenderer:setZOrder(100)
  self.skeletonRenderer:setSkeleton("spark/spark.json")

  self.transform.localScale = Vector(self.properties.scale, self.properties.scale)
  self.time = self.properties.minTime + Random.value() * (self.properties.maxTime - self.properties.minTime)
  self.skeletonRenderer:setAnimation(0, self.properties.animationName)
end

function Spark:update(deltaTime)
  self.time = self.time - deltaTime
  if self.time < 0.0 then
    self.skeletonRenderer:setAnimation(0, self.properties.animationName)
    self.time = self.properties.minTime + Random.value() * (self.properties.maxTime - self.properties.minTime)
  end
end
