local InteractionIndicator = Behavior("InteractionIndicator")

InteractionIndicator.editorIcon("indicator/indicator.json")

function InteractionIndicator:initialize()
  local renderer = self:addComponent("SkeletonRenderer")
  renderer.skeleton = "indicator/indicator.json"
  renderer.zOrder = 1000
  renderer:setAnimation(0, "idle", true)
  renderer.tintColor = Color(1.0, 1.0, 1.0, 0.0)
end

function InteractionIndicator:update()
  if self.mainCo then
    if not self.mainCo:update() then
      self.mainCo = nil
    end
  end
end

function InteractionIndicator:show(small)
  local renderer = self.skeletonRenderer
  if small then
    renderer:setAnimation(0, "idle", true)
  else
    renderer:setAnimation(0, "idle_big", true)
  end

  self.mainCo = Co.create(function()
    local color = renderer.tintColor

    Co.sleep(0.01)

    while color.a < 1.0 do
      color.a = math.min(1.0, color.a + Time.fixedDeltaTime * 8.0)
      renderer.tintColor = color
      Co.yield()
    end
  end)
end

function InteractionIndicator:hide()
  self.mainCo = Co.create(function()
    local renderer = self.skeletonRenderer
    local color = renderer.tintColor

    while color.a > 0.0 do
      color.a = math.max(0.0, color.a - Time.fixedDeltaTime * 8.0)
      renderer.tintColor = color
      Co.yield()
    end
  end)
end
