local TraderJoe = Behavior("TraderJoe")

TraderJoe.editorIcon("trader_joe/trader_joe.json")

local OnHitQuips = {
  "Stop it.",
  "Knock it off."
}

function TraderJoe:initialize()
  local soundEmitter = self:addComponent("SoundEmitter")

  local inventory = self:addComponent("Inventory")
  self.inventory:addItems("HealingPotion", 50)
  self.inventory:addItems("GreaterHealingPotion", 50)
  self.inventory:addItems("StaminaPotion", 50)
  self.inventory:addItems("GreaterStaminaPotion", 50)
  self.inventory:addItems("SecondChance", 50)
  self.inventory:addItems("RuneShard", 50)
  self.inventory:addItems("Cloverleaf", 1)
  self.inventory.coins = 1000000

  local renderer = self:addComponent("SkeletonRenderer")
  renderer:enableEvents()
  renderer.zOrder = 100
  renderer.skeleton = "trader_joe/trader_joe.json"

  local collider = self:addComponent("PhysicsCollider")
  collider.categories = flags(World.layer("MovementCollider"), World.layer("Interactable"))
  collider.mask = World.layer("MovementCollider")
  collider:addCircleShape(Vector(0.0, 8.0), 16.0)
  collider:addRectangleShape(Vector(-28.0, 4.0), Vector(48.0, 24.0))
  collider.type = collider.Types.Static

  local hitbox = CreateObject("Hitbox", Vector.zero(), self.object):addComponent("PhysicsCollider")
  hitbox.categories = World.layer("Hitbox")
  hitbox.mask = World.layer("Weapon")
  hitbox:addCircleShape(Vector(0.0, 24.0), 16.0)
  hitbox.type = collider.Types.Static

  hitbox.object:on("collisionStart", function()
    self.actor:stopAllScripts()
    self.actor:playScript("getHit")
  end)

  self:setupActor()

  self.object:on("use", function()
    Kernel.tradingView:show(self.inventory)
  end)
end

function TraderJoe:update(deltaTime)
  if self.textCo then
    if not self.textCo:update() then
      self.textCo = nil
    end
  end
end

function TraderJoe:setupActor()
  local actor = self:addComponent("Actor")

  actor:addScript("idle", function()
    self.skeletonRenderer:setAnimation(0, "idle", true)
  end)

  actor:addScript("getHit", function()
    self.soundEmitter:postEvent("TraderJoeGetHit")

    local quip = table.pickOne(OnHitQuips)
    self:say(quip)

    self.skeletonRenderer:setAnimation(0, "get_hit", true)
    WaitForAnimation("get_hit")
    return actor:playScript("idle")
  end)

  actor:playScript("idle")
end

function TraderJoe:say(text)
  if self.bubble then
    self.bubble.object:destroy()
  end

  self.bubble = CreateObject("SpeechBubble", Vector(0.0, 128.0), self.object):addComponent("SpeechBubble")
  self.bubble:setText(text)

  self.textCo = Co.create(function ()
    while not self.bubble.done do
      Co.yield()
    end

    Co.sleep(3.0)

    self.bubble.object:destroy()
    self.bubble = nil
  end)
end
