local AI = require "util/aicommon"

local MiniBossProjectile = Behavior("MiniBossProjectile")

MiniBossProjectile.editorIcon("mini_boss_projectile/mini_boss_projectile.json")

function MiniBossProjectile:initialize(properties)
  self.properties = properties

  local renderer = self:addComponent("SkeletonRenderer")
  renderer.skeleton = "mini_boss_projectile/mini_boss_projectile.json"
  renderer.zOrder = 105
  renderer:setFlag(renderer.Flags.AlwaysFront)
  renderer:enableEvents()

  renderer:setAnimation(0, "idle", true)

  local soundEmitter = self:addComponent("SoundEmitter")
  local transform = self.transform

  local collided = false

  self.object:on("collisionStart", function(collisionInfo)
    if collided then
      return
    end

    if collisionInfo.object == self.properties.parentHitbox then
      return
    end

    if not collisionInfo.object.character then
      return
    end

    collided = true
    self.mainCo = self.collideFn
  end)

  self:addComponent("Weapon")
  local collider = self.physicsCollider
  collider.type = collider.Types.Kinematic
  collider:addCircleShape(Vector(0.0, 0.0), 24.0, { isSensor = true })
  collider.mask = World.layer("Hitbox")

  self.weapon.staminaMultiplier = 4.0
  self.weapon:startAttack(120)

  self.weapon.movementDirection = self.properties.velocity

  self.weapon.onApplyEffects = function(object)
    if object.statusEffects then
      local dir = (object.transform.worldPosition - self.transform.worldPosition):normalized()
      object.statusEffects:applyByName("Knockback", { impulse = dir * 8000.0 })
    end
  end

  self.collideFn = Co.create(function()
    soundEmitter:postEvent("BarrelBreak")
    self.object:destroy()
  end)

  self.moveFn = Co.create(function()
    while true do
      transform.localPosition = transform.worldPosition + self.properties.velocity * Time.fixedDeltaTime * self.properties.speed
      Co.yield()
    end
  end)

  self.mainCo = self.moveFn
  self.telegraphDone = false
end

function MiniBossProjectile:fixedUpdate()
  if not self.mainCo:update() then
    self.object:destroy()
  end
end

function MiniBossProjectile:selfDestruct()
  self.physicsCollider.mask = 0
  self.mainCo = self.collideFn
end
