local AI = require "util/aicommon"

local MoriProjectile = Behavior("MoriProjectile")

MoriProjectile.editorIcon("healer_projectile/healer_projectile.json")

function MoriProjectile:initialize(properties)
  self.properties = properties

  local renderer = self:addComponent("SkeletonRenderer")
  renderer.skeleton = "healer_projectile/healer_projectile.json"
  renderer.zOrder = 100
  renderer:enableEvents()
  renderer.timeScale = 1.0

  local soundEmitter = self:addComponent("SoundEmitter")

  local transform = self.transform

  local collided = false

  self.object:on("collisionStart", function(collisionInfo)
    if collided then
      return
    end
    
    if collisionInfo.object == self.properties.parentHitbox then
      return
    end

    if collisionInfo.object._objectId == 0 then
      collided = true
      self.mainCo = self.collideFn
      return
    end

    local parent = collisionInfo.object
    if parent and parent.transform.parent then
      parent = parent.transform.parent.object
    end

    if parent then
      local statusEffects = parent.statusEffects
      if statusEffects then
        statusEffects:applyByName("Healing", { amount = self.properties.healAmount, duration = self.properties.healDuration })
      end
    end

    collided = true
    self.mainCo = self.collideFn
  end)

  self:addComponent("PhysicsCollider")
  self.physicsCollider:addCircleShape(Vector(0.0), 14.0)

  self.physicsCollider.mask = 0
  self.physicsCollider.categories = World.layer("Weapon")

  self.collideFn = Co.create(function()
    soundEmitter:postEvent("PreacherProjectileSmash")
    renderer:setAnimation(0, "smash", false)
    AI.yieldWaitForAnimation(self.object, "smash")
    self.object:destroy()
  end)

  self.telegraphFn = Co.create(function()
    self.telegraphDone = true
    renderer.timeScale = 1.0
    renderer:setAnimation(0, "idle", true)
    self.physicsCollider.mask = flags(World.layer("Hitbox"), World.layer("World"))
    self.mainCo = self.moveFn
  end)

  self.moveFn = Co.create(function()
    while true do
      transform.localPosition = transform.worldPosition + self.properties.velocity * Time.fixedDeltaTime * self.properties.speed
      Co.yield()
    end
  end)

  self.telegraphDone = false
  self.mainCo = self.telegraphFn
end

function MoriProjectile:fixedUpdate()
  if not self.mainCo:update() then
    self.object:destroy()
  end
end

function MoriProjectile:selfDestruct()
  self.physicsCollider.mask = 0
  self.mainCo = self.collideFn
end
