local AI = require "util/aicommon"

local PreacherProjectile = Behavior("PreacherProjectile")

PreacherProjectile.editorIcon("preacher_projectile/preacher_projectile.json")

function PreacherProjectile:initialize(properties)
  self.properties = properties

  local renderer = self:addComponent("SkeletonRenderer")
  renderer.skeleton = "preacher_projectile/preacher_projectile.json"
  renderer.zOrder = 100
  renderer:enableEvents()

  renderer.timeScale = 2.75
  renderer:setAnimation(0, "telegraph", false)
  renderer:fastForward(0.1)

  local soundEmitter = self:addComponent("SoundEmitter")

  local transform = self.transform

  local collided = false

  self.object:on("collisionStart", function(collisionInfo)
    if collided then
      return
    end

    if collisionInfo.object._objectId == 0 then
      collided = true
      self.mainCo = self.collideFn
      return
    end

    if collisionInfo.object == self.properties.parentHitbox then
      return
    end

    collided = true
    self.mainCo = self.collideFn
  end)

  local weapon = self:addComponent("Weapon")
  weapon.movementDirection = self.properties.velocity

  self.physicsCollider:addCircleShape(Vector(0.0), 14.0)
  self.physicsCollider.mask = 0

  self.collideFn = Co.create(function()
    soundEmitter:postEvent("PreacherProjectileSmash")
    renderer:setAnimation(0, "smash", false)
    AI.yieldWaitForAnimation(self.object, "smash")
    self.object:destroy()
  end)

  self.telegraphFn = Co.create(function()
    AI.yieldWaitForAnimation(self.object, "telegraph")
    renderer.timeScale = 1.0
    renderer:setAnimation(0, "idle", true)
    self.telegraphDone = true

    self.physicsCollider.mask = flags(World.layer("Hitbox"), World.layer("World"))
    self.weapon:startAttack(self.properties.damage)
    self.weapon:shouldConnect(properties.parent)

    self.mainCo = self.moveFn
  end)

  self.moveFn = Co.create(function()
    while true do
      transform.localPosition = transform.worldPosition + self.properties.velocity * Time.fixedDeltaTime * self.properties.speed
      Co.yield()
    end
  end)

  self.mainCo = self.telegraphFn
  self.telegraphDone = false
end

function PreacherProjectile:fixedUpdate()
  if not self.mainCo:update() then
    self.object:destroy()
  end
end

function PreacherProjectile:selfDestruct()
  self.physicsCollider.mask = 0
  self.mainCo = self.collideFn
end
