local SaveGameStats = require "util/savegamestats"

local AI = require "util/aicommon"
local LootSpawner = require "util/lootspawner"

local TrainingDummy = Behavior("TrainingDummy")

TrainingDummy.editorIcon("dummy/dummy.json")
TrainingDummy.property("wind", false)

function TrainingDummy:initialize(properties)
  self.properties = TrainingDummy.defaultProperties(properties)

  self:addComponent("Character", {
    faction = self.properties.faction,
    hp = self.properties.hp,
    collisionRadius = 28.0,
    colliderDisplacement = Vector(0.0, 8.0),
    colliderDensity = 128.0,
    skeleton = {
      s = "dummy/dummy.json"
    }
  })

  if self.properties.wind then
    self.character:setAnimation("idle_wind", true)
  else
    self.character:setAnimation("idle", true)
  end

  self:removeComponent("StatusEffects")
  self.physicsCollider.type = self.physicsCollider.Types.Static

  self:setupColliders()
  self.character:setLinkedColliders({
    bb_body = self.bodyHitbox.object
  })

  self.character:setSkeleton("s")
end

function TrainingDummy:setWind(wind)
  self.properties.wind = wind

  if self.properties.wind then
    self.character:setAnimation("idle_wind", true)
  else
    self.character:setAnimation("idle", true)
  end

  self.skeletonRenderer:fastForward(Random.value() * 8.0)
end

function TrainingDummy:setupColliders()
  self.bodyHitbox = CreateObject("BodyHitbox", Vector.zero(), self.object):addComponent("Hitbox")
  self.bodyHitbox:on("collisionStart", function(collisionInfo)
    local transform = collisionInfo.object.transform
    if transform.parent then
      transform = transform.parent
    end

    local dir = transform.worldPosition - self.transform.worldPosition
    dir:normalize()
    self.soundEmitter:postEvent("HeroHitEnvironment")

    if Random.value() < 0.01 then
      self.character:say("You're a dummy.")
    end

    if math.abs(dir.x) > math.abs(dir.y) then
      if dir.x < 0.0 then
        self.character:setAnimation("get_hit_left")
      else
        self.character:setAnimation("get_hit_right")
      end
    else
      if dir.y < 0.0 then
        self.character:setAnimation("get_hit_up")
      else
        self.character:setAnimation("get_hit_down")
      end
    end

    if self.properties.wind then
      self.character:addAnimation("idle_wind", true)
    else
      self.character:addAnimation("idle", true)
    end
  end)
end
