local MusicController = Behavior("MusicController")

function MusicController:initialize()
  local sound = Kernel:addComponent("SoundEmitter")

  self.object:on("destroy", function()
    sound:postEvent("StopEnvironmentSounds")
    sound:postEvent("StopMusic")
  end)

  local masterVolume = Config.getKey("sound", "masterVolume", "float")
  local musicVolume = Config.getKey("sound", "musicVolume", "float")
  local sfxVolume = Config.getKey("sound", "sfxVolume", "float")
  local ambientVolume = Config.getKey("sound", "ambientVolume", "float")

  sound:setRTPC("MasterVolume", masterVolume * 100.0, true)
  sound:setRTPC("MusicVolume", musicVolume * 100.0, true)
  sound:setRTPC("SfxVolume", sfxVolume * 100.0, true)
  sound:setRTPC("AmbientVolume", ambientVolume * 100.0, true)

  if World.isLoaded() then
    sound:postEvent("StopEnvironmentSounds")

    if Config.getKey("sound", "ambientSounds", "bool") then
      sound:postEvent("PlayEnvironmentSounds")
    end

    sound:postEvent("StopMusic")
    if Config.getKey("sound", "music", "bool") then
      sound:postEvent("PlayMusic")
    end
  end

  self.bossMusic = false

  self.musicCo = Co.create(function()
    self.soundEmitter:setSwitch("Music", "PlayExplorationMusic")

    while true do
      Co.yieldRunWhile(function()
        return self.heroRef.health.isAlive
      end, function()
        while true do
          local enemy = self:isEnemyInRange(300.0)
          if enemy then
            self.soundEmitter:setSwitch("Music", "PlayCombatMusic")

            while self:isEnemyInRange(300.0) do
              Co.sleep(16.0)
            end
          else
            self.soundEmitter:setSwitch("Music", "PlayExplorationMusic")
            Co.sleep(16.0)
          end

          Co.sleep(0.5)
        end
      end)

      if not self.heroRef.health.isAlive then
        self.soundEmitter:setSwitch("Music", "PlayHeroDeathMusic")
      end

      Co.yield()
    end
  end)
end

function MusicController:awake()
  self.heroRef = BehaviorUtil.findFirstOfType("Hero")
end

function MusicController:update(deltaTime)
  if not self.heroRef then
    return
  end

  if not self.musicCo:update() then
    self.musicCo:reset()
  end
end

function MusicController:playBossMusic()
  self.soundEmitter:setSwitch("Music", "PlayBossMusic")
  self.musicCo = Co.create(function()
    while true do
      Co.sleep(1.0)
    end
  end)
end

function MusicController:playMainMenuMusic()
  self.soundEmitter:setSwitch("Music", "PlayMainMenuMusic")
  self.musicCo = Co.create(function()
    while true do
      Co.sleep(1.0)
    end
  end)
end

function MusicController:isEnemyInRange(range)
  local enemyFound = false

  self.heroRef.character:forEachEntityInRange(range, function(object)
    if not object.character then
      return true
    end

    if object.character.faction ~= "Heroes" and object.character.faction ~= "Neutral" then
      enemyFound = true
      return false
    end

    return true
  end, World.layer("MovementCollider"))

  return enemyFound
end