local AIPerformanceTest = Behavior("AIPerformanceTest")

function AIPerformanceTest:initialize()
  self.nextSpawnTimer = 0.0
  Camera.setPosition(Vector(0.0, 0.0))
end

function AIPerformanceTest:update(deltaTime)
  self.nextSpawnTimer = self.nextSpawnTimer - deltaTime
  if self.nextSpawnTimer < 0.0 then
    self.nextSpawnTimer = 0.05
    self:spawn()
  end
end

function AIPerformanceTest:spawn()
  local world = World.getCurrent()
  local position = (Vector(0.1, 0.1) + Random.vector() * 0.8) * world:getPixelSize()

  local behaviorName = "Draugur"
  if Random.value() <= 0.5 then
    behaviorName = "Knight"
  end

  local instance = CreateObject(behaviorName, position):addComponent(behaviorName)
  instance.health.totalHp = 1
  instance.health.hp = 1
  instance.character.faction = tostring(Random.value())
end
