local CollisionAvoidanceTest = Behavior("CollisionAvoidanceTest")

function CollisionAvoidanceTest:initialize()
  self.position = nil
end

function CollisionAvoidanceTest:update(deltaTime)
  local mousePos = Input.getMouseWorldPosition()
  mousePos = mousePos
  
  if Input.getMouseButtonHeld(1) then
    self.position = mousePos
  end

  if self.position then
    local size = 32
    local tileSize = Vector(16.0, 16.0)

    for x=0,size do
      for y=0,size do
        local samplePos = self.position + tileSize * Vector(x - size * 0.5, y - size * 0.5)
        local sample = Pathfinding.sampleCollisionAvoidance(samplePos)

        if sample:len() > 0.0 then
          Debug.drawLine(samplePos, samplePos + sample * 128.0, 0xFF00FFFF)
        end
      end
    end
  end
end
