local CoroutineTest = Behavior("CoroutineTest")

function CoroutineTest:initialize()
  local printHello = Co.create(function()
    local count = 5
    while count > 0 do
      print("hello world")
      Co.sleep(0.25)
      count = count - 1
    end
  end)

  local printMsg = Co.create(function(msg, dispose)
    if dispose then
      print("DISPOSED")
      return
    end

    while true do
      print(msg)
      Co.sleep(1.0)
    end
  end)

  self.co = Co.create(function ()
    local count = 0

    Co.concurrent(printHello, printMsg("test"))
  end)
end

function CoroutineTest:update(deltaTime)
  self.co:update()
end
