local DummyKnight = Behavior("DummyKnight")

function DummyKnight:initialize()
  self:setupColliders()

  self:addComponent("Character", {
    faction = "Knights",
    hp = 300,
    movementSpeed = 32.0,
    collisionRadius = 8.0,
    colliderDisplacement = Vector(0.0, 2.0),
    colliderDensity = 10.0,
    skeleton = {
      down = "knight/knight_down.json",
      up = "knight/knight_up.json",
      left = "knight/knight_left.json",
      right = "knight/knight_right.json"
    },
    colliders = {
      bb_body = self.bodyHitbox.object,
      bb_weapon = self.sword.object
    }
  })

  self.character:setSkeleton("down")

  self:addComponent("Healthbar", Vector(-9.0, 30.0))
  self:addComponent("FootstepsRenderer")

  self.spawnPosition = self.transform.worldPosition
  self.isRunning = false
  self.stamina = 1.0

  self.walkSpeed = 36.0
  self.runSpeed = 52.0

  self:setupActor()
end

function DummyKnight:setupActor()
  local actor = self.actor

  actor:addScript("getHit", function()
    self.movable.velocity = Vector.zero()

    self.skeletonRenderer.timeScale = 1.8
    self.character:setAnimation("get_hit", false)
    WaitForAnimation("get_hit")
    self.skeletonRenderer.timeScale = 1.0

    WaitForNumberOfFrames(0)
    self.physicsCollider:clearForces()
  end)
end

function DummyKnight:setupColliders()
  self.bodyHitbox = CreateObject("BodyHitbox", Vector.zero(), self.object):addComponent("Hitbox", "Knights")
  self.sword = CreateObject("Sword", Vector.zero(), self.object):addComponent("Weapon", "Knights")

  self.bodyHitbox.object:on("collisionStart", function(collisionInfo)
    local weapon = collisionInfo.object.weapon
    if not weapon or not self.health.isAlive then
      return
    end

    if weapon.faction == self.character.faction then
      return
    end
    
    if weapon:shouldConnect(self.object) then
      local bloodPosition = self.bodyHitbox.transform.worldPosition
      local bloodDirection = (bloodPosition - weapon.transform.worldPosition):normalized()
      CreateObject("BloodParticles", bloodPosition):addComponent("BloodParticles", bloodDirection)

      local knockbackDir = weapon:getKnockbackDirection(self.transform.worldPosition)
      self.physicsCollider:applyForceToCenter(knockbackDir:normalized() * 600.0)
      self.actor:stopAllScripts()
      self.actor:playScript("getHit")
    end
  end)
end

