local EnemySpawner = Behavior("EnemySpawner")

EnemySpawner.property("enemyType", "Knight")
EnemySpawner.property("radius", 64.0)

function EnemySpawner:initialize(properties)
  self.properties = EnemySpawner.defaultProperties(properties)
  self.enemy = nil
  self.dead = {}
end

function EnemySpawner:update(deltaTime)
  if not self.enemy then
    self:spawnEnemy()
  end

  if not self.enemy.health.isAlive then
    self.enemy = nil
  end
end

function EnemySpawner:spawnEnemy()
  local angle = Random.value() * 3.1415 * 2.0
  local position = Vector(math.cos(angle), math.sin(angle)) * self.properties.radius
  self.enemy = CreateObject(self.properties.enemyType, self.transform.worldPosition + position):addComponent(self.properties.enemyType)
  self.enemy.health.hp = 150
  self.enemy.health.totalHp = 150
end
