local HeroAnimTest = Behavior("HeroAnimTest")

function HeroAnimTest:initialize()
  local skeletons = {
    "hero/hero_left_up.json",
    "hero/hero_left.json",
    "hero/hero_left_down.json",
    "hero/hero_down.json",
    "hero/hero_right_down.json",
    "hero/hero_right.json",
    "hero/hero_right_up.json",
    "hero/hero_up.json",
  }

  self.skeletons = skeletons

  local anims = {
    "idle",
    "walk",
    "hit",
    "get_hit",
    "jump_back",
    "block_start",
    "block_active",
    "block_active_move",
    "block_release"
  }

  self.anims = anims

  local x = 128.0
  local y = 64.0

  for q, anim in ipairs(anims) do
    for i, skeleton in ipairs(skeletons) do
      self:spawnSkeleton(Vector(x, y), skeleton, anim)
      x = x + 128.0
    end

    y = y + 96.0
    x = 128.0
  end

  Camera.setPosition(Vector.zero())

  self.rotatingHero = CreateObject("HeroSkeleton")
  local renderer = self.rotatingHero:addComponent("SkeletonRenderer")
  renderer.skeleton = skeletons[1]
  self.rotatingHero.transform.localPosition = Vector(1280.0, 400.0)
  self.rotatingIndex = 1
  self.nextRotation = 0.0
end

function HeroAnimTest:update(deltaTime)
  self.nextRotation = self.nextRotation - deltaTime
  if self.nextRotation < 0.0 then
    self.rotatingIndex = self.rotatingIndex + 1
    if self.rotatingIndex > #self.skeletons then
      self.rotatingIndex = 1
    end

    self.rotatingHero.skeletonRenderer.skeleton = self.skeletons[self.rotatingIndex]
    self.nextRotation = 0.1
  end
end

function HeroAnimTest:spawnSkeleton(position, skeleton, anim)
  local object = CreateObject("HeroSkeleton")
  local renderer = object:addComponent("SkeletonRenderer")
  object.transform.localPosition = position
  renderer.skeleton = skeleton
  renderer:setAnimation(0, anim, true)
end
