local PathfindingTest = Behavior("PathfindingTest")

function PathfindingTest:initialize()
  self.pos0 = Vector(0, 0)
  self.pos1 = Vector(0, 0)
  self.minWallDistance = 16.0
end

function PathfindingTest:update(deltaTime)
  local mousePos = Input.getMouseWorldPosition()
  mousePos = mousePos
  
  local recalc = false

  if Input.getMouseButtonHeld(0) then
    self.pos0 = mousePos
    recalc = true
  end
  
  if Input.getMouseButtonHeld(1) then
    self.pos1 = mousePos  
    recalc = true
  end

  if recalc then
    Pathfinding.findPath(self.pos0, self.pos1, function (path)
      self.path = path
      for i, node in ipairs(self.path.nodes) do
        Pathfinding.pullNodeAwayFromWalls(self.path, i, 40.0)
      end
    end)
  end
  
  Debug.drawCircle(self.pos0, 6.0, 0x0000FFFF)
  Debug.drawCircle(self.pos1, 6.0, 0x0000FFFF)

  if self.path ~= nil then
    self.path:drawDebug()
  end
end
