local PathfollowerTest = Behavior("PathfollowerTest")

function PathfollowerTest:initialize()
  self.char = CreateObject("Eve", self.transform.worldPosition):addComponent("Eve")
  --self.char:addComponent("CameraFollow")

  local world = World.getCurrent()
  self.worldSize = world:getSize() * world:getTileSize()

  Input.onKeyDown(KEYS.KEY_SPACE, function()
    local pos = Vector(Random.value() * self.worldSize.x, Random.value() * self.worldSize.y)
    self.char.actor:playScript("goTo", pos)
  end)

  Input.onMouseButtonDown(0, function(pressed)
    if pressed then
      self:setTarget(Input.getMouseWorldPosition())
    end
  end)

  Camera.setPosition(Vector.zero())
  Camera.setSize(Vector(1920.0, 1080.0))

  self.target = nil
end

function PathfollowerTest:update(deltaTime)
  if self.target then
    Debug.drawCircle(self.target, 6.0, 0x00A7A7FF, true)
  end
end

function PathfollowerTest:setTarget(target)
  self.char:goTo(target)
  self.target = target
end
