local RaycastTest = Behavior("RaycastTest")

function RaycastTest:initialize()
  self.pos0 = Vector(0, 0)
  self.pos1 = Vector(0, 0)
end

function RaycastTest:update(deltaTime)
  local mousePos = Input.getMouseWorldPosition()
  mousePos = mousePos
  
  if Input.getMouseButtonHeld(0) then
    self.pos0 = mousePos
  end
  
  if Input.getMouseButtonHeld(1) then
    self.pos1 = mousePos
  end
  
  Debug.drawCircle(self.pos0, 6.0, 0x0000FFFF)
  Debug.drawCircle(self.pos1, 6.0, 0x0000FFFF)

  local hit = nil
  Physics.raycast(self.pos0, self.pos1, function(hitInfo)
    if not hit then
      hit = hitInfo
    elseif Vector.distance(self.pos0, hitInfo.point) < Vector.distance(self.pos0, hit.point) then
      hit = hitInfo
    end

    return 1.0
  end)

  Debug.drawLine(self.pos0, self.pos1, 0xFF00FFFF)
  if hit then
    Debug.drawCircle(hit.point, 6.0, 0xFFFFFFFF)
  end
end
