local Healthbar = Behavior("Healthbar")

function Healthbar:initialize(displacement)
  self.image = AssetUtil.find("default/pixel.png")
  self.displacement = displacement or Vector(0.0, 126.0)
  self.size = Vector(48.0, 8.0)

  self.bgColor = Color(0.8, 0.8, 0.8, 1.0)
  self.hpColor = Color(0.9, 0.2, 0.2, 1.0)

  self.alpha = 1.0
  self.transparency = 1.0
end

function Healthbar:awake()
  if self.character and self.character.properties.isLarge then
    self.size = Vector(128.0, 14.0)
  end
end

function Healthbar:update(deltaTime)
  local hp = self.health.hp
  local totalHp = self.health.totalHp
  if hp >= totalHp then
    return
  end

  if hp <= 0.0 then
    self.transparency = self.transparency - deltaTime * 8.0
    if self.transparency < 0.0 then
      self.transparency = 0.0
    end
  end

  local alpha = 0.0
  if totalHp > 0.0 then
    alpha = hp / totalHp
  end
  
  if not math.epsCompare(self.alpha, alpha, deltaTime) then
    if self.alpha > alpha then
      self.alpha = self.alpha - deltaTime
    elseif self.alpha < alpha then
      self.alpha = self.alpha + deltaTime
    end
  end

  local position = self.transform:getWorldPosition() + self.displacement - Vector(self.size.x * 0.5, 0.0)

  Graphics.drawImage(self.image, {
    position = position,
    size = self.size,
    zOrder = 1000,
    tint = self.bgColor * self.transparency,
    isUI = true
  })

  Graphics.drawImage(self.image, {
    position = position,
    size = Vector(self.size.x * alpha, self.size.y),
    zOrder = 1000,
    tint = self.hpColor * self.transparency,
    isUI = true
  })
end
