local MenuEvents = Behavior("MenuEvents")

function MenuEvents:initialize()
  self.lock = nil
end

function MenuEvents:takeLock(lockName)
  if self.lock ~= nil then
    return self.lock == lockName
  end

  self.lock = lockName
  return true
end

function MenuEvents:releaseLock(lockName)
  if self.lock ~= lockName then
    return false
  end

  self.lock = nil
  return true
end

function MenuEvents:hasLock(lockName)
  return self.lock == lockName
end
