local ItemDefs = require "data/itemdefs"

local HUD = Behavior("HUD")

function HUD:initialize()
  self.visible = true
  UI.attachView("HUD", "ui/hud.rml")

  self.bindings = {
    watermark = not _EDITOR,
    hpPercent = 100.0,
    stPercent = 100.0,
    dpadClass = "",
    quickBar = nil
  }

  Input.onKeyDown(KEYS.KEY_F9, function()
    if self.visible then
      self:hide()
    else
      self:show()
    end
  end)

  Kernel.inputController:on("quickUse1", function(pressed)
    if Kernel.menuEvents.lock then
      return
    end

    self.bindings.dpadClass = "up"
    setTimeout(function()
      self.bindings.dpadClass = ""
    end, 0.25)

    self:useConsumable("up")
  end)

  Kernel.inputController:on("quickUse3", function(pressed)
    if Kernel.menuEvents.lock then
      return
    end

    self.bindings.dpadClass = "down"
    setTimeout(function()
      self.bindings.dpadClass = ""
    end, 0.25)

    self:useConsumable("down")
  end)

  Kernel.inputController:on("quickUse4", function(pressed)
    if Kernel.menuEvents.lock then
      return
    end

    self.bindings.dpadClass = "left"
    setTimeout(function()
      self.bindings.dpadClass = ""
    end, 0.25)

    self:useConsumable("left")
  end)

  Kernel.inputController:on("quickUse2", function(pressed)
    if Kernel.menuEvents.lock then
      return
    end
    
    self.bindings.dpadClass = "right"
    setTimeout(function()
      self.bindings.dpadClass = ""
    end, 0.25)

    self:useConsumable("right")
  end)

  self:on("destroy", function()
    UI.detachView("HUD")
  end)

  self.alpha = 1.0
end

function HUD:show()
  if not self.visible then
    self.visible = true
    UI.attachView("HUD", "ui/hud.rml")
  end
end

function HUD:hide()
  if self.visible then
    self.visible = false
    UI.detachView("HUD")
  end
end

function HUD:awake()
  self.heroRef = BehaviorUtil.findFirstOfType("Hero")
end

function HUD:update(deltaTime)
  if not self.heroRef or not self.visible then
    return
  end

  self.alpha = self.alpha + deltaTime

  local health = self.heroRef.health

  if health.totalHp > 0.0 then
    self.bindings.hpPercent = (health.hp / health.totalHp) * 100.0
  end

  if self.heroRef.totalStamina > 0.0 then
    self.bindings.stPercent = (self.heroRef.stamina / self.heroRef.totalStamina) * 100.0
  end

  local inventory = self.heroRef.inventory

  self.bindings.quickBar = {}
  for position, itemId in pairs(self.heroRef.quickBar.slots) do
    self.bindings.quickBar[position] = {
      id = itemId,
      def = ItemDefs[itemId],
      qty = inventory.items[itemId]
    }
  end

  local statusEffects = {}
  for name, statusEffect in pairs(self.heroRef.statusEffects.stacks) do
    if not statusEffect.ended and not statusEffect.doNotDisplay then
      statusEffects[#statusEffects+1] = name
    end
  end
  
  self.bindings.statusEffects = statusEffects
  self.bindings.alpha = math.abs(math.sin(self.alpha))
  self.bindings.watermark = not _EDITOR and not Kernel.menuEvents.lock
  UI.updateBinding("HUD", self.bindings)
end

function HUD:useConsumable(slot)
  if not self.heroRef or not self.heroRef.health.isAlive then
    return
  end
  
  local itemId = self.heroRef.quickBar.slots[slot]

  if not itemId then
    return
  end

  local inventory = self.heroRef.inventory
  local qty = inventory.items[itemId]
  if not qty or qty == 0 then
    return
  end

  self.heroRef.character:useConsumable(itemId)
end
